<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Front-end class.
 *
 * @package     availability_ctsubmission
 * @copyright   2022 Michael Gardener <mgardener@cissq.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace availability_ctsubmission;

use assignsubmission_ctsubmission\output\ct_overview;

defined('MOODLE_INTERNAL') || die();

/**
 *
 */
class frontend extends \core_availability\frontend {
    /**
     * @var array Cached init parameters
     */
    protected $cacheparams = [];

    /**
     * @var string IDs of course, cm, and section for cache (if any)
     */
    protected $cachekey = '';

    /**
     * @return string[]
     */
    protected function get_javascript_strings() {
        return ['label_cm'];
    }

    /**
     * @param $course
     * @param \cm_info|null $cm
     * @param \section_info|null $section
     * @return array|array[]
     * @throws \coding_exception
     * @throws \moodle_exception
     */
    protected function get_javascript_init_params($course, \cm_info $cm = null, \section_info $section = null) {
        ct_overview::set_course_groups($course);

        // Use cached result if available. The cache is just because we call it
        // twice (once from allow_add) so it's nice to avoid doing all the
        // print_string calls twice.
        $cachekey = $course->id . ',' . ($cm ? $cm->id : '') . ($section ? $section->id : '');
        if ($cachekey !== $this->cachekey) {
            // Get list of activities on course which have completion values,
            // to fill the dropdown.
            $context = \context_course::instance($course->id);
            $cms = [];
            $previouscm = false;
            foreach ($course->assigns as $assign) {
                $othercm = get_coursemodule_from_instance('assign', $assign->assignment, 0, false, MUST_EXIST);
                if ((empty($cm) || $cm->id != $othercm->id)) {
                    $cms[] = (object)[
                        'id' => $othercm->id,
                        'name' => format_string($assign->name, true, ['context' => $context]),
                    ];
                }
            }
            $this->cachekey = $cachekey;
            $this->cacheinitparams = [$cms];
        }
        return $this->cacheinitparams;
    }

    /**
     * @param $course
     * @param \cm_info|null $cm
     * @param \section_info|null $section
     * @return bool
     * @throws \coding_exception
     * @throws \moodle_exception
     */
    protected function allow_add($course, \cm_info $cm = null, \section_info $section = null) {
        return true;
    }
}

