<?php
/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;

define('NO_OUTPUT_BUFFERING', true);

require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

require_login();
$title = NED\str('activitybulksettingschanger');
$url = new moodle_url( NED\PLUGIN_URL.basename(__FILE__));
$PAGE->set_context(\context_system::instance());
$PAGE->set_url($url);
$PAGE->set_title($title);
$PAGE->set_heading($title);

$mform = new NED\form\activity_settings_changer();
if ($mform->is_cancelled()) {
    redirect($url);
}

echo $OUTPUT->header();
if (!is_siteadmin()){
    SH::print_error('nopermissions', 'error', '', '');
}

if ($mform->get_data()) {
    $res = $mform->do_action();
    if ($res === true){
        NED\redirect_continue($url,
            NED\str('updatedsuccessfully'),
            \core\output\notification::NOTIFY_SUCCESS
        );
    } else {
        $errors = [];
        if (is_string($res)){
            $errors = [$res];
        } elseif (is_array($res)){
            $errors = $res;
        }

        if (!empty($errors)){
            foreach ($errors as $error){
                echo $OUTPUT->notification($error, \core\output\notification::NOTIFY_ERROR);
            }
            NED\redirect_continue($url);
        } else {
            echo $OUTPUT->notification(NED\str('noactivitiesbyfilter'), \core\output\notification::NOTIFY_INFO);
            echo $mform->draw();
        }
    }
} else {
    echo $mform->draw();
}
echo $OUTPUT->footer();
