/**
 * AMD for grading_tracker_render page
 *
 * @module     block_ned_teacher_tools/grading_tracker_render
 * @package    block_ned_teacher_tools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'block_ned_teacher_tools/modal_form', 'core/str', 'core/notification'],
function($, ModalForm, Str, Notification) {
    let plugin = 'block_ned_teacher_tools';
    return {
        init: function(contextid) {
            let $table = $('table.nedtable');
            let $gtr = $('.grading-tracker-render');

            let $ned_checkboxes = $table.find('tbody .record .ned_tags_checkbox');
            $table.delegate('thead .ned_tags_checkbox', 'change', function(e){
                $ned_checkboxes.prop('checked', e.target.checked);
            });

            $gtr.delegate('.ned-actionmenu .dropdown-menu a', 'click', function(e){
                e.preventDefault();
                let $elem = $(e.target);
                if (!$elem.has('.callform, .link')){
                    return;
                }

                let gtids;
                if ($elem.closest('.bulk-menu').length){
                    gtids = $ned_checkboxes.filter(':checked').map((i, el) => $(el).data('id')).get();
                    if (!gtids.length){
                        str_alert('noselectedrecords');
                        return;
                    }
                } else {
                    gtids = $elem.closest('tr.record').data('id');
                    if (!gtids){
                        str_alert('unexpectederror');
                        return;
                    }
                    gtids = [gtids];
                }

                if ($elem.hasClass('link')){
                    let url = $elem.attr('href');
                    let pattern = encodeURI('{ids}');
                    if (url.includes(pattern)){
                        url = url.replace(pattern, gtids.join(','));
                        document.location.replace(url);
                        return;
                    }
                }

                let title = 'form';
                let methodname = false;
                let links = ['reportbug', 'unreportbug', 'setcounted', 'setuncounted', 'gthide', 'gtshow', 'refreshnow'];
                for (let type of links){
                    if ($elem.hasClass(type)){
                        title = type;
                        methodname = 'form_' + type;
                        break;
                    }
                }

                if (methodname){
                    let data = {
                        title: title ? Str.get_string(title, plugin) : '',
                        classname: `\\${plugin}\\grading_tracker`,
                        methodname: methodname,
                        urlparams: GetUrlParams(),
                        gtid: gtids,
                        finish_if_body_ok: true,
                        callback_body_ok: function(){
                            if (this.last_response && typeof this.last_response !== "string"){
                                if (this.last_response['reload']){
                                    document.location.reload();
                                    return;
                                }

                                let replace_id = this.last_response['replace_id'];
                                if (replace_id){
                                    let replace = this.last_response['replace'];
                                    let selector = `tr.record[data-id=${replace_id}]`;
                                    if (replace){
                                        $table.find(selector).replaceWith(replace);
                                    } else {
                                        $table.find(selector).remove();
                                    }

                                }

                                if (this.last_response['notifications']){
                                    let notifs = this.last_response['notifications'];
                                    if (notifs['message']){
                                        notifs = [notifs];
                                    }

                                    for (let i=0; i<notifs.length; i++ ){
                                        Notification.addNotification({
                                            message: notifs[i]['message'] || '',
                                            type: notifs[i]['type'] || 'info',
                                        });
                                    }
                                }
                            }
                        },
                    };
                    ModalForm.init(contextid, data);
                }
            });
        }
    };

    function GetUrlParams(){
        const queryString = window.location.search;
        const urlParams = new URLSearchParams(queryString);
        const entries = urlParams.entries();
        let params = {};
        for(const entry of entries) {
            params[entry[0]] = entry[1];
        }

        return params;
    }

    function str_alert(key, pl=plugin, $a=null){
        $.when(Str.get_string(key, pl, $a)).done(function(localizedEditString) {
            alert(localizedEditString);
        });
    }
});
