define(['jquery', 'core/log'], function($, log) { return {
init: function() {
    let selector = '.marking-manager .moodle-dialogue.assignfeedback_editpdf_widget .moodle-dialogue-hd > span.yui3-widget-buttons';
    let fullscreen = 'fullscreen';
    $(document).delegate(selector, 'click', function (e) {
        let widget_content = $(e.target).closest('.assignfeedback_editpdf_widget > div.moodle-dialogue-content');
        if (e.target.tagName.toLowerCase() === 'button'){
            // button close the window
            if (widget_content.hasClass(fullscreen)){
                closeFullscreen(widget_content);
                widget_content.removeClass(fullscreen);
            }
        } else {
            // pseudo button toggle fullscreen
            toggleFullscreen(widget_content);
            widget_content.toggleClass(fullscreen);
        }
        return true;
    });

    function toggleFullscreen(elem, condition) {
        condition = condition || elem.hasClass(fullscreen);
        condition ? closeFullscreen(elem) : openFullscreen(elem);
    }

    function openFullscreen(elem) {
        if (elem.length){
            elem = elem[0];
        }
        elem.requestFullscreen = elem.requestFullscreen || elem.mozRequestFullScreen || elem.webkitRequestFullscreen || elem.msRequestFullscreen;
        elem.requestFullscreen ? elem.requestFullscreen() : log.warn('There are no requestFullscreen function');
    }

    function closeFullscreen(elem) {
        if (!document.fullscreen){
            return;
        }
        document.exitFullscreen = document.exitFullscreen || document.mozCancelFullScreen || document.webkitExitFullscreen || document.msExitFullscreen;
        document.exitFullscreen ? document.exitFullscreen() : log.warn('There are no closeFullscreen function');
    }

}
};});
