// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'core/log'], function ($, log) {
    return {
        init: function(name, url) {
            let $autocomplete = $('.ned-single-autocomplete-'+name);
            let def_value = '' + $autocomplete.data('value');
            $autocomplete.on('select', 'select', function (e) {
                $(e.target).on('change', function(e){
                    let value = e.target.value;
                    if (value === '' || value === def_value){
                        return;
                    }
                    url += url.indexOf('?') > -1 ? '&' : '?';
                    url += name + '=' + value;
                    window.location.href = url;
                });
            })
        }
    };
});
