define(['jquery', 'core/str', 'local_ned_controller/show_ned_notify'], function($, str, NED_Notify) {
    return {
        init: function(note) {
            let plugin = 'ned_teacher_tools';
            let plugin_name = 'block_' + plugin;

            let student = $('#mark-interface .generalinfo .gi-value.student');
            if (!student.length){
                return;
            }
            student = student.text().trim();

            $('#mark-interface table.student-progress').delegate('.ned-actionmenu a', 'click', function(e){
                let $e = $(e.target);
                if ($e.hasClass('removesubmissiondata')){
                    note.template = plugin_name+'/submission_reset_warning';
                } else if ($e.hasClass('allowresubmission')){
                    note.template = plugin_name+'/submission_allow_resubmission';
                } else {
                    return true;
                }

                e.preventDefault();
                let $row = $(this).closest('tr');
                let activity = $row.find('a.mod-link').text().trim();
                let url = this.href;
                note.template_context = {activity: activity, student: student};
                NED_Notify.show_one(note, function($target){
                    if ($target.hasClass('btn-ok')){
                        let data = $target.closest('.ned-notification-window').find('form').serialize();
                        if (data){
                            url += '&' + data;
                        }
                        document.location.replace(url);
                    }
                });
                return false;
            });
        }
    };
});