<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

use local_ned_controller\tt_config_manager as CM;
use block_ned_teacher_tools\shared_lib as SH;

/**
 * Class restore_ned_teacher_tools_block_task
 */
class restore_ned_teacher_tools_block_task extends restore_block_task {
    /**
     *
     */
    protected function define_my_settings(){
        // No settings.
    }

    /**
     * @return array
     */
    public function get_fileareas(){
        return array(); // No fileareas.
    }

    /**
     * @return array
     */
    public function get_configdata_encoded_attributes(){
        return array(); // No special handleing of configdata.
    }

    /**
     * Define (add) particular steps that each block can have
     */
    protected function define_my_steps(){
        // No steps to take.
    }

    /**
     * @throws dml_exception
     */
    public function after_restore(){
        $blockid = $this->get_blockid();
        $courseid = $this->get_courseid();
        if (empty($blockid) || empty($courseid)) return;

        // Get new block config
        $block_config = SH::get_block_config($courseid, SH::TT_NAME);
        if ($block_config->block_id != $blockid) return;

        $cfg_fields = CM::BASE_CONFIG_FIELDS;
        $configs_to_save = $this->_get_saved_custom_settings($block_config, $cfg_fields);

        foreach ($cfg_fields as $field){
            unset($block_config->$field);
        }

        SH::save_block_config($courseid, SH::TT_NAME, $block_config);
        if (!empty($configs_to_save)){
            CM::save_config_data_in_course($configs_to_save, $courseid);
        }
    }

    /**
     * Update config data to point to the new course modules.
     *
     * @param object $block_config {@see SH::get_block_config()}
     * @param array $cfg_fields - field names defined in {@see \local_ned_controller\tt_config_manager}
     *
     * @return array custom config to insert|update
     */
    protected function _get_saved_custom_settings($block_config, $cfg_fields){
        $configs_to_save = [];
        $add_single_cfg = function($cmid, $field) use (&$configs_to_save){
            $config_record = $configs_to_save[$cmid] ?? [];
            $config_record[$field] = CM::VALUE_ACTIVE;
            $configs_to_save[$cmid] = $config_record;
        };
        $check_new_cm = function($oldcmid){
            $new_cm = restore_dbops::get_backup_ids_record($this->get_restoreid(), 'course_module', $oldcmid);
            return $new_cm ? $new_cm->newitemid : false;
        };
        $check_settings = function($cfg_field) use ($block_config, $add_single_cfg, $check_new_cm){
            if (empty($block_config->$cfg_field)) return;

            foreach ($block_config->$cfg_field as $oldcmid){
                if ($new_cmid = $check_new_cm($oldcmid)){
                    $add_single_cfg($new_cmid, $cfg_field);
                }
            }
        };

        foreach ($cfg_fields as $field){
            $check_settings($field);
        }

        return $configs_to_save;
    }

    /**
     * @return array
     */
    static public function define_decode_contents(){
        return array(); // Nothing to do.
    }

    /**
     * @return array
     */
    static public function define_decode_rules(){
        return array(); // Nothing to do.
    }
}
