<?php
/**
 * @package    block_ned_teacher_tools
 * @subpackage form
 * @category   NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\form;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->libdir.'/formslib.php');

/**
 * Form.
 *
 * @package    block_ned_teacher_tools
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class class_extension extends \moodleform {

    /**
     * Form definition
     */
    public function definition() {
        global $DB;

        $mform = $this->_form;
        $data  = $this->_customdata;
        $group = $DB->get_record('groups', ['id' => $data['groupid']], '*', MUST_EXIST);

        if ($group->enddate) {
            $mform->addElement('static', 'description', SH::str('currentenddate'),
                (($group->enddate) ? date('d M Y', $group->enddate) : '')
            );
        }

        $mform->addElement('hidden', 'groupid', $data['groupid']);
        $mform->setType('hidden', PARAM_INT);

        $mform->addElement('date_selector', 'enddate', SH::str('newenddate'), ['optional' => false]);
        $mform->addRule('enddate', '', 'required', SH::str('required'), 'client');

        $mform->addElement('textarea', 'reason', '',
            ['wrap' => 'virtual',  'rows' => "5", 'cols' => "50", 'placeholder' => SH::str('reasonforextension') . '...']);
        $mform->addRule('reason', '', 'required', get_string('required'), 'client');
    }
}
