<?php
/**
 * Some support objects for form classes
 *
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\shared_lib as SH;

/*
 * Trait for moodleform_mod classes (or even moodleform)
 */
Trait trait_moodleform_mod{
    /** @var string name of the form */
    protected $_formname;       // form name
    /** @var MoodleQuickForm quickform object definition */
    protected $_form;
    /** @var string name of module. */
    protected $_modname;

    public function __construct($current, $section, $cm, $course) {
        // Guess module name if not set.
        if (is_null($this->_modname)) {
            $matches = array();
            if (!preg_match('/.*mod_([^_]+)_mod_form$/', get_class($this), $matches)) {
                debugging('Rename form to mod_xx_mod_form, where xx is name of your module');
                SH::print_error('unknownmodulename');
            }
            $this->_modname = $matches[1];
        }
        /** @var \moodleform_mod parent */
        parent::__construct($current, $section, $cm, $course);
    }

    /**
     * Return form data without been submitted
     * @param null $elementList
     * @param bool $unset_necessary
     *
     * @return object|null
     */
    public function exportValues($elementList=null, $unset_necessary=true){
        $data = $this->_form->exportValues($elementList);
        if ($data){
            if ($unset_necessary){
                unset($data['sesskey']); // we do not need to return sesskey
                unset($data['_qf__'.$this->_formname]);   // we do not need the submission marker too
            }

            return (object)$data;
        }

        return null;
    }
}
