<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    block_ned_teacher_tools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

use block_ned_teacher_tools as NED;

require_once('deadline_manager_report_overview.php');

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->dirroot . "/lib/completionlib.php");


class course_completion_status_manager_users extends deadline_manager_report_overview
{

    public function __construct()
    {
        parent::__construct(null, [], null, [], null, null, new \stdClass());
    }

    /**
     * Export page contents for template
     *
     * @param \renderer_base $output
     *
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output)
    {
        global $DB;
        $capabilities = [
            'moodle/grade:viewall',
        ];

        $data = new \stdClass();
        $data->overview_all = true;
        $data->canmanagegroups = false;
        $statuses = [
            NED\course_users_status::STATUS_WAITING_FOR_FINAL_GRADE => NED\str('waitinggrade'),
            NED\course_users_status::STATUS_WAITING_FOR_INTERNAL_REVIEW => NED\str('waitinginternalreview')
        ];
        $subs = NED\get_statuses_users_by_statuses(array_keys($statuses));
        $courses = [];

        foreach ($subs as $userstatus) {
            if (!isset($courses[$userstatus->courseid])){
                $course = get_course($userstatus->courseid);
                if ($course->format == 'site') {
                    continue;
                }
                $course_context = \context_course::instance($course->id);
                if (!has_any_capability($capabilities, $course_context)) {
                    continue;
                }
                $courses[$userstatus->courseid] = $course;
            } else {
                $course = $courses[$userstatus->courseid];
            }

            $course_context = $course_context ?? \context_course::instance($course->id);
            $daywaiting = NED\get_diff_dates($userstatus->timeupdated, time(), [NED\str('day'), NED\str('days')]);
            $teachers = NED\get_group_teachers_by_course_context_userid($userstatus->courseid, $course_context->id, $userstatus->userid);
            $student = $DB->get_record('user', ['id' => $userstatus->userid]);
            $teacherdata = [];
            if (count($teachers) > 1){
                $teacherdata = ['name' => \html_writer::tag('i', NED\str('multiple'))];
            } elseif(count($teachers) == 1){
                $teacher = reset($teachers);
                $teacherdata = [
                    'name' => fullname($teacher),
                    'url' => new \moodle_url('/user/profile.php', ['id' => $teacher->id])
                ];
            }

            $datastatus = [
                'schoolid' => $userstatus->schoolid,
                'student' => [
                    'name' => fullname($student),
                    'url' => new \moodle_url('/user/profile.php', ['id' => $student->id])
                ],
                'teacher' => $teacherdata,
                'coursecode' => $userstatus->coursecode,
                'status' => $statuses[$userstatus->status],
                'daywaiting' => $daywaiting,
                'daywaitingurl' => new \moodle_url(NED\PLUGIN_URL . 'progress_report.php', ['courseid' => $course->id]),
            ];
            $data->userstatuses[] = $datastatus;
        }
        return $data;
    }
}
