<?php
/**
 * Deadline Manager Report
 *
 * @package    block_ned_teacher_tools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

use block_ned_teacher_tools\deadline_manager as DM;
use block_ned_teacher_tools\output\menu_bar as MB;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die();
/** @var \stdClass $CFG */
require_once($CFG->dirroot . '/lib/grouplib.php');


/**
 * abstract class deadline_manager_report as base for deadline_manager_report_* classes
 *
 * @package block_ned_teacher_tools\output
 *
 * @property-read \stdClass $course;
 * @property-read array $groups;
 * @property-read \stdClass $group;
 * @property-read array $enrolledusers;
 * @property-read \stdClass $user;
 * @property-read array $pageparams;
 * @property-read \context|\context_course $context;
 */
abstract class deadline_manager_report implements \renderable, \templatable {

    protected $_course;
    protected $_groups;
    protected $_group;
    protected $_enrolledusers;
    protected $_user;
    protected $_pageparams;
    protected $_context;
    protected $_show_inactive;

    /**
     * deadline_manager_report constructor.
     *
     * @param \stdClass $course
     * @param array     $groups
     * @param \stdClass $group
     * @param array     $enrolledusers
     * @param \stdClass $user
     * @param array     $pageparams
     * @param \context|\context_course $context
     * @param bool|null $show_inactive
     */
    public function __construct($course, $groups, $group, $enrolledusers, $user, $pageparams=[], $context=null, $show_inactive=null) {
        $this->_course = $course;
        $this->_context = $context ? $context :  SH::ctx($course->id);
        $this->_group = $group;
        $this->_groups = $groups;
        $this->_enrolledusers = $enrolledusers;
        $this->_user = $user;
        $this->_pageparams = $pageparams;
        $this->_show_inactive = $show_inactive;
    }

    /**
     * @param $name
     *
     * @return mixed
     */
    public function __get($name){
        $name = '_' . $name;
        return property_exists($this, $name) ? $this->$name : null;
    }

    /**
     * @return \stdClass
     */
    public function get_course(){
        return $this->_course;
    }

    /**
     * Return format date, if variable not empty, empty string otherwise
     * @param $date
     *
     * @return false|string
     */
    static public function strdate($date){
        return empty($date) ? '' : date('j M Y', $date);
    }

    /**
     * Return list or users by there role name in group, as one string
     * @param      $role_name
     * @param null $other_group
     *
     * @return string
     */
    public function get_users_by_role($role_name, $other_group=null){
        $group = $other_group ? $other_group : $this->_group;
        return implode(', ', DM::get_role_users_fullnames($role_name, $this->_context, $group->id, true, $this->_course->id));
    }

    /**
     * Return link to page by page name and class page params (and merged params)
     * @param       $page
     * @param array $merge_params
     *
     * @return string
     */
    public function make_url($page, $merge_params=[]){
        $url = MB::get_page_moodle_url($page, array_merge($this->_pageparams, $merge_params));
        return $url->out(false);
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    abstract public function export_for_template(\renderer_base $output);

}
