<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager Header
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\deadline_manager as DM;

defined('MOODLE_INTERNAL') || die();

/**
 * Class deadline_manager_report_group - for the single group
 *
 * @package block_ned_teacher_tools\output
 */
class deadline_manager_report_group extends deadline_manager_report {

    /**
     * Export page contents for template
     * @param \renderer_base $output
     *
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {
        global $USER;

        $data = new \stdClass();
        $data->contextid = SH::ctx($this->course->id)->id;

        if (empty($this->_group)) {
            return $data;
        }

        // Cohort.
        if ($cohort = DM::get_school_cohort($this->group)) {
            if (!empty($cohort->timezone)) {
                $data->viewtimezone = SH::has_capability('view_timezone_menu', $this->_context);
                $data->school = $cohort->name;
                $data->timezone = $cohort->timezone;
                if ($cohort->timezone == $USER->timezone) {
                    $data->timezoneinfo = strtoupper(substr($cohort->name, 0, 4)) . ' ' . get_string('time');
                } else {
                    $data->timezoneinfo = SH::str('rosedaleofficetime');
                }
            }
        }

        $groupusers = $this->_enrolledusers;
        $numberofstudents = count($groupusers);
        $student_ids = array_keys($groupusers);

        $dm_entity = DM::get_dm_entity($this->_course, $this->_group);
        foreach ($dm_entity->iterate() as $cmid => $dma){
            if (!$dma->is_enabled()) continue;

            $row = $dma->get_row();
            $tags = SH::cm_get_tags($row->cmid);

            if (in_array(SH::TAG_LAST_ACTIVITY, $tags)) {
                $row->activity .= SH::tag('span', SH::TAG_LAST_ACTIVITY,
                    array('class' => 'badge badge-info ml-1'));
            }

            // Number of graded
            $row->numofgrades = $dma->get_number_of_grades($student_ids);
            $row->numberofstudents = $numberofstudents;

            if (empty($row->raw_deadline)){
                $row->deadline = SH::str('duedaterequired');
                $row->daterequired = true;
            }

            $data->activities[] = $row;
        }

        $data->hasactivities = !empty($data->activities);

        return $data;
    }
}