<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager Header
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

use block_ned_teacher_tools\output\menu_bar as MB;
use block_ned_teacher_tools\shared_lib as SH;

require_once('deadline_manager_report_overview.php');

defined('MOODLE_INTERNAL') || die();


/**
 * Class deadline_manager_report_overview_all - overview ALL sites by exploit deadline_manager_report_overview class
 * @see deadline_manager_report_overview
 *
 * @package block_ned_teacher_tools\output
 */
class deadline_manager_report_overview_all extends deadline_manager_report_overview{
    protected $category_id;

    /**
     * deadline_manager_report_overview_all constructor.
     *
     * @param int $category_id
     */
    public function __construct($category_id) {
        $this->category_id = $category_id;
        parent::__construct(null, [], null, [],null, [], SH::ctx(), false);
    }

    /**
     * Export page contents for template
     *
     * @param \renderer_base $output
     *
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {
        $data = new \stdClass();
        if ($this->category_id < 0) return $data;

        if ($this->category_id){
            $courses = \core_course_category::get($this->category_id, MUST_EXIST, true)->get_courses(['recursive' => 1]);
        } else {
            $courses = $courses = get_courses();
        }

        $capabilities = ['view_all_groups', 'view_own_groups', 'deadlineviewonly'];
        $data->overview_all = true;
        $data->canmanagegroups = false;
        $groups = [];

        foreach ($courses as $course){
            $course_context = SH::ctx($course->id);
            if (!SH::has_any_capability($capabilities, $course_context)) continue;

            list($show_inactive, $allgroups, $group, $groupid, $allstudents, $enrolledusers, $user, $userid) =
                MB::get_showinactive_groups_group_groupid_allstudents_students_user($course, false, 0, 0, true);
            if (empty($allgroups)) continue;

            $this->_course = $course;
            $this->_context = $course_context;
            $this->_group = $group;
            $this->_groups = $allgroups;
            $this->_enrolledusers = $enrolledusers;
            $this->_user = $user;
            $this->_show_inactive = false;
            $this->_pageparams = [MB::PAR_COURSE => $course->id];

            $group_data = parent::export_for_template($output);
            $course_data = (object)[
                'shortname' => $course->shortname,
                'fullname' => $course->fullname,
                'url' => new \moodle_url('/course/view.php', ['id' => $course->id])
            ];
            foreach ($group_data->groups as $group){
                $group->course = $course_data;
                $key = $group->raw_enddate ?? -1;
                if (!isset($groups[$key])){
                    $groups[$key] = [];
                }
                $groups[$key][] = $group;
            }
            $data->canmanagegroups = $data->canmanagegroups || $group_data->canmanagegroups;
        }

        if ($data->hasgroups = !empty($groups)){
            krsort($groups);
            $data->groups = array_merge(...$groups);
        } else {
            $data->groups = [];
        }

        return $data;
    }
}
