<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use block_ned_teacher_tools\grading_tracker as GT;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die;
require_once(__DIR__. '/../../lib.php');

/**
 * Class adhoc_crongt_notify
 *
 * @package block_ned_teacher_tools\task
 */
class adhoc_crongt_notify extends adhoc_base_crongt {
    use \local_ned_controller\task\base_task;

    /**
     * If return false, task will not execute
     *
     * @return bool
     */
    public function can_execute(){
        if (parent::can_execute()){
            $config = SH::get_config();
            if (!$config->crongt_notify_enable){
                static::print('adhoc_crongt_notify is not enable, pass.');
                return false;
            }

            return true;
        }

        return false;
    }

    /**
     * Do task job without any checks
     *
     * @param array|object|adhoc_crongt_notify|null $task_or_data
     *
     * @return void
     */
    static public function do_job($task_or_data=[]){
        $p = function(...$args){
            static::print(...$args);
        };
        $data = static::get_data_from_task_or_data($task_or_data);
        $graderid = $data['graderid'] ?? 0;

        list($all_checked, $notifies) = GT::check_gt_notifications($graderid, $p);
        if ($all_checked){
            static::print("Successfully checked $all_checked teachers, $notifies from them get notifications.");
        } else {
            static::print("Couldn't find any teachers to check.");
        }
    }
}
