<?php
/**
 * @package    block_ned_teacher_tools
 * @subpackage task
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use block_ned_teacher_tools\shared_lib as NED;
use block_ned_teacher_tools\deadline_manager as DM;
use local_ned_controller\task\base_adhoc_task;
use local_ned_controller\task\base_task;

/**
 * Class adhoc_delete_extensions
 * @package block_ned_teacher_tools\task
 */
class adhoc_delete_extensions extends base_adhoc_task {
    use base_task;

    /**
     * {@inheritDoc}
     */
    static public function do_job($task_or_data = []){
        $params = static::get_data_from_task_or_data($task_or_data);
        $validated_params = [];

        $fields = [
            NED::PAR_GROUP  => 'groupid',
            NED::PAR_USER   => 'userid',
            NED::PAR_CM     => 'cmid',
            NED::PAR_COURSE => 'courseid',
        ];

        foreach ($fields as $field => $db_field){
            if (empty($params[$field])) continue;

            $validated_params[$db_field] = $params[$field];
        }

        if (empty($validated_params)){
            static::print('Incorrect input parameters. End task.');
            return;
        }

        $to_delete = NED::db()->get_records(DM::TABLE_EXTENSION, $validated_params);
        if (empty($to_delete)){
            static::print('There are no records to delete with '.static::_arr_to_str($validated_params));
            return;
        }

        $count_records = count($to_delete);
        static::print('There are '.$count_records.' records to delete with '.static::_arr_to_str($validated_params));

        foreach ($to_delete as $record){
            $params_for_print = ['userid' => $record->userid, 'cmid' => $record->cmid, 'courseid' => $record->courseid];
            static::print('Delete record with id '.$record->id.'. Params: '.static::_arr_to_str($params_for_print));

            DM::delete_extension($record->userid, $record->cmid, $record->courseid);
            static::print('Record id='.$record->id.' has been deleted');
        }
    }

    /**
     * @param array $arr associative array
     *
     * @return string which contains all elements from array like "key"="value" using delimiter ' AND '
     */
    static protected function _arr_to_str($arr){
        $res = '';
        array_walk($arr, function($v, $k) use (&$res){
            $res .= '"'.$k.'" = "'.$v.'" AND ';
        });

        return rtrim($res, ' AND');
    }
}
