<?php

/**
 * Auto set “waiting for grade” status
 *
 * @package    block_ned_teacher_tools
 */

namespace block_ned_teacher_tools\task;

/** @var \stdClass $CFG */
use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\course_users_status;

defined('MOODLE_INTERNAL') || die();
require_once $CFG->dirroot . '/blocks/ned_teacher_tools/common_lib.php';
require_once $CFG->dirroot . '/blocks/ned_teacher_tools/local_lib.php';
require_once $CFG->dirroot . '/local/ned_controller/lib.php';

class auto_set_waiting_for_grade extends \core\task\scheduled_task
{

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public function get_name(){
        return NED\str('auto_set_waiting_for_grade');
    }

    /**
     * Do the job.
     * Throw exceptions on errors (the job will be retried).
     */
    public function execute(){
        global $PAGE;
        $config = get_config(NED\PLUGIN_NAME);
        if (!($config->enablecoursecompletionstatuscontroller ?? false)){
            mtrace(NED\str('enablecoursecompletionstatuscontroller').' is off, pass.');
            return true;
        }

        $course_cats = $config->coursecompletionstatuscontroller_coursecategories ?? '';
        $course_cats = explode(',', $course_cats);

        $PAGE->set_url(new \moodle_url('/'));

        $courses_with_exam = NED\get_courses_with_exam_mod_id();

        foreach ($courses_with_exam as $course) {

            $block_config = NED\get_block_config($course->id, NED\PLUGIN);

            if (empty($block_config->autosetwfgstatus)) {
                continue;
            }

            if (!NED\course_cats_has_courseid($course_cats, $course->id)){
                continue;
            }

            $cus = new course_users_status($course->id);
            $cus_statuses = $cus->get_users_statuses();
            $students = NED\get_enrolled_users($course->id, \context_course::instance($course->id));

            $modexams = explode(',', $course->exammodid);

            foreach ($students as $studentid => $student) {

                if (isset($cus_statuses[$studentid])) {
                    if ($cus_statuses[$studentid]->status != course_users_status::STATUS_IN_PROGRESS) {
                        continue;
                    }
                }

                $completedexams = 0;
                foreach ($modexams as $modexam) {
                    mtrace('exammodid:' . $modexam);
                    list($c, $cm) = get_course_and_cm_from_cmid($modexam);
                    $assign = new \assign($cm->context, $cm, $c);

                    $assign_instance = $assign->get_instance();
                    if (!empty($assign_instance->cutoffdate) && time() >= $assign_instance->cutoffdate) {
                        $completedexams++;
                    } else {
                        $submission = $assign->get_assign_submission_status_renderable($student, false)->submission;
                        if (!$submission){
                            break;
                        }
                        $grading_status = $assign->get_grading_status($studentid);
                        if ($grading_status == ASSIGN_GRADING_STATUS_NOT_GRADED && $submission->status == ASSIGN_SUBMISSION_STATUS_SUBMITTED) {
                            $completedexams++;
                        } else {
                            break;
                        }
                    }
                }

                if (count($modexams) == $completedexams) {
                    if (!empty($cus->add_user_status($studentid, course_users_status::STATUS_WAITING_FOR_FINAL_GRADE))) {
                        mtrace('set status for ' . $studentid);
                    } else {
                        mtrace('FAIL set status for ' . $studentid);
                    }
                }
            }
        }
        return true;
    }
}
