<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once(__DIR__.'/lib.php');
require_once(NED\PLUGIN_PATH.'/classes/output/course_completion_status_manager.php');
require_once(NED\PLUGIN_PATH.'/classes/output/course_completion_status_manager_users.php');

require_login();
$context = context_system::instance();

// Set the url.
$thispageurl = new moodle_url(NED\PLUGIN_URL.'course_completion_status_manager.php');
$title = NED\str('coursecompletionstatusmanager');

$PAGE->set_context($context);
$PAGE->set_url($thispageurl);
$PAGE->set_title($title);
$PAGE->set_heading($title);

SH::$C::js_call_amd('add_sorter', 'add_sort', ['table.nedtable']);

$PAGE->navbar->add(NED\str('pluginname'));
$PAGE->navbar->add($title);
$PAGE->add_body_class('path-blocks-NED');
$renderer = $PAGE->get_renderer(NED\PLUGIN_NAME);
list($output, $ccsm_class) = NED\get_tabs_for_course_completion_status_manager();
$classname = 'block_ned_teacher_tools\\output\\' . $ccsm_class;
$output .= $renderer->render(new $classname());

echo $OUTPUT->header();
echo $output;
echo $OUTPUT->footer();
