<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

function xmldb_block_ned_teacher_tools_uninstall() {

    global $DB;

    $dbman = $DB->get_manager();

    // Groups.
    $table = new xmldb_table('groups');
    $field = new xmldb_field('schedule');
    if ($dbman->field_exists($table, $field)) {
        $dbman->drop_field($table, $field);
    }
    $field = new xmldb_field('startdate');
    if ($dbman->field_exists($table, $field)) {
        $dbman->drop_field($table, $field);
    }
    $field = new xmldb_field('enddate');
    if ($dbman->field_exists($table, $field)) {
        $dbman->drop_field($table, $field);
    }

    // Cohort.
    $table = new xmldb_table('cohort');
    $field = new xmldb_field('timezone');
    if ($dbman->field_exists($table, $field)) {
        $dbman->drop_field($table, $field);
    }
    $table = new xmldb_table('cohort');
    $field = new xmldb_field('location');
    if ($dbman->field_exists($table, $field)) {
        $dbman->drop_field($table, $field);
    }

    // Overrule
    $field = new xmldb_field('overrule');
    $tables = ['assign_overrides', 'quiz_overrides'];
    foreach ($tables as $table_name){
        $table = new xmldb_table($table_name);
        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }
    }

    return true;
}
