<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\deadline_manager as DM;
use block_ned_teacher_tools\output\menu_bar as MB;
use block_ned_teacher_tools\shared_lib as SH;

if (!isset($CFG)){
    require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
}
require_once(__DIR__ . '/lib.php');
require_once($CFG->libdir.'/adminlib.php');

$page      = optional_param('page', 0, PARAM_INT);
$perpage   = optional_param('perpage', 20, PARAM_INT);
$find_missed = optional_param(SH::PAR_DM_TO_MISSED, false, PARAM_BOOL);

$MB = new MB(MB::PAGE_DM, ['page' => $page, 'perpage' => $perpage]);
$dm_capabilities = [
    NED\PLUGIN_CAPABILITY . 'view_all_groups',
    NED\PLUGIN_CAPABILITY . 'view_own_groups',
    NED\PLUGIN_CAPABILITY . 'deadlineviewonly'
];
$MB->show_error_for_not_teacher(false, $dm_capabilities);

if ($find_missed && $MB->course){
    $DM = new DM($MB->course->id);
    if ($missed_group = $DM->has_missed_schedule()){
        redirect($MB->get_url(null, [MB::PAR_GROUP => $missed_group]));
    }
}

$coursecontext = $MB->context;
$group = $MB->group;
$user = $MB->user;
$course = $MB->course;
$pagetype = $MB->pagesubtype;

if ($group) {
    DM::set_dm_timezone($group);
}

$add_body_class = 'path-blocks-ned_teacher_tools page-blocks-ned_teacher_tools-deadline_manager';
$called_from_somewhere = $PAGE->has_set_url();
if (!$called_from_somewhere){
    // Set the url.
    $thispageurl = $MB->get_url();

    $PAGE->set_url($thispageurl);
    $title = NED\str('deadlinemanager');
    $PAGE->set_title($course->shortname . ': ' . $title);
    $PAGE->set_heading($course->fullname . ': ' . $title);

    $PAGE->navbar->add($title, MB::get_page_moodle_url(MB::PAGE_DM, [MB::PAR_COURSE => $course->id, MB::PAR_GROUP => 0, MB::PAR_USER => 0]));
    if ($group) {
        $PAGE->navbar->add($group->name, $MB->get_url(MB::PAGE_DM, [MB::PAR_SUBTYPE => DM::PAGE_GROUP]));
    }
    if ($user && $pagetype == DM::PAGE_USER) {
        $PAGE->navbar->add(fullname($user), $MB->get_url(MB::PAGE_DM, [MB::PAR_SUBTYPE => DM::PAGE_USER]));
    }
    $PAGE->add_body_class($add_body_class);

    echo $OUTPUT->header();
} else {
    echo html_writer::script("window.document.body.className += ' $add_body_class';");
}

$renderer = $PAGE->get_renderer(NED\PLUGIN_NAME);
if ($pref = get_user_preferences('block_ned_teacher_tools_showttbar', 0)) {
    echo $renderer->render($MB);
}
$reportheader = new NED\output\deadline_manager_header($pagetype, $course, $group, $user, $MB->pageparams, $coursecontext);
echo $renderer->render($reportheader);

if ($MB->act || empty($groups = $MB->allgroups)){
    echo DM::get_dm_report_by_pagetype($pagetype,
        [$MB->course, $MB->allgroups, $MB->group, $MB->students, $MB->user, $MB->pageparams, $MB->context],
        true);
}

if (!$called_from_somewhere){
    echo $OUTPUT->footer();
}
