<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\deadline_manager as DM;
use block_ned_teacher_tools\output\menu_bar as MB;

if (!isset($CFG)){
    require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
}
require_once(__DIR__ . '/lib.php');
require_once($CFG->libdir.'/adminlib.php');

$MB = new MB(MB::PAGE_DM_EDIT);
$MB->show_error_for_not_teacher();
$group = $MB->group;
$user = $MB->user;
$course = $MB->course;
$ctx = $MB->context;
$pagetype = $MB->pagesubtype;
$user_edit = ($user && $pagetype == DM::PAGE_USER_EDIT);

if (!($user_edit ? DM::can_edit_user_deadline($ctx) : DM::can_edit_group_deadline($ctx))){
    SH::print_error('nopermissions', 'error', '', get_string('checkpermissions', 'core_role'));
}

// Set the url.
$thispageurl = $MB->get_url();
$returnurl = $MB->get_url(MB::PAGE_DM, [MB::PAR_SUBTYPE => $user_edit ? DM::PAGE_USER : DM::PAGE_GROUP]);

$title = SH::str('deadlinemanager');
$PAGE->set_url($thispageurl);
$PAGE->set_title($course->shortname . ': ' . $title);
$PAGE->set_heading($course->fullname . ': ' . $title);

// Nav bar.
$PAGE->navbar->add($title, MB::get_page_moodle_url(MB::PAGE_DM, [MB::PAR_COURSE => $course->id, MB::PAR_GROUP => 0, MB::PAR_USER => 0]));
if ($group) {
    $PAGE->navbar->add($group->name, $MB->get_url(MB::PAGE_DM, [MB::PAR_SUBTYPE => DM::PAGE_GROUP]));
}
if ($user_edit) {
    $PAGE->navbar->add(fullname($user), $MB->get_url(MB::PAGE_DM, [MB::PAR_SUBTYPE => DM::PAGE_USER]));
} else {
    $user = null;
}
$PAGE->navbar->add(SH::str('managedeadlines'));

$mform = new \block_ned_teacher_tools\form\deadline_manager_edit_form($thispageurl,
    ['dm_entity' => DM::get_dm_entity($course, $group, $user), 'pagetype' => $pagetype]
);
if ($mform->is_cancelled()) {
    redirect($returnurl);
} elseif ($fromform = $mform->get_data()) {
    $source = $mform->get_current_source();
    if (!$mform->dm_entity->was_manually_edited($source)){
        // normally we have already loaded data during the validation
        $mform->dm_entity->form_load_data($fromform, $source);
    }

    $mform->dm_entity->save_data($source);
    redirect($returnurl);
    die;
}

echo $OUTPUT->header();
echo SH::render($MB);
$reportheader = new \block_ned_teacher_tools\output\deadline_manager_header($pagetype, $course, $group, $user, $MB->pageparams, $MB->context);
echo SH::render($reportheader);
$mform->set_data(null);
$mform->display();
echo $OUTPUT->footer();
