<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\output\menu_bar as MB;

require_once('../../config.php');

$courseid = required_param('courseid', PARAM_INT); // Course id.
$id = optional_param('id', 0, PARAM_INT); // Mod id to look at.
$mid = optional_param('mid', 0, PARAM_INT); // Mod id to look at.
$cmid = 0;                                 // If no mid is specified, we'll select one in this variable.

// From mod grade files.
$dir = optional_param('dir', 'DESC', PARAM_ALPHA);
$timenow = optional_param('timenow', 0, PARAM_INT);
$action = optional_param('action', '', PARAM_ALPHA);

// Paging options.
$page = optional_param('page', 0, PARAM_INT);
$perpage = optional_param('perpage', 20, PARAM_INT);

// Filtering Options.
$menushow = optional_param('menushow', 'unmarked', PARAM_ALPHA);
$sort = optional_param('sort', 'date', PARAM_ALPHANUM);
$show = optional_param('show', 'unmarked', PARAM_ALPHA);
$view = optional_param('view', 'less', PARAM_ALPHA);

$userid = optional_param('userid', 0, PARAM_INT);
$groupid = optional_param('group', null, PARAM_INT);
$expand = optional_param('expand', 0, PARAM_INT);
$rownum = optional_param('rownum', 0, PARAM_INT);


$unsubmitted = optional_param('unsubmitted', '0', PARAM_INT);
$activitytype = optional_param('activity_type', '0', PARAM_TEXT);
$participants = optional_param('participants', '0', PARAM_INT);
$show_inactive = optional_param('show_inactive', null, PARAM_INT);

$fn_gradebook = optional_param('fn_gradebook', false, PARAM_BOOL);

$pageparams = array(
    'courseid' => $courseid,
    'userid' => $userid,
    'mid' => $mid,
    'dir' => $dir,
    'group' => $groupid,
    'timenow' => $timenow,
    'action' => $action,
    'expand' => $expand,
    'activity_type' => $activitytype,
    'rownum' => $rownum,
    'page' => $page,
    'perpage' => $perpage,
    'menushow' => $menushow,
    'sort' => $sort,
    'view' => $view,
    'show' => $show,
    'unsubmitted' => $unsubmitted,
    'show_inactive' => $show_inactive,
    'participants' => $participants
);

if (!$fn_gradebook){
    redirect(new moodle_url('/blocks/ned_teacher_tools/marking_manager.php', $pageparams));
}

require_once(__DIR__ . '/lib.php');
require_once($CFG->dirroot . '/course/lib.php');
require_once($CFG->dirroot . '/lib/plagiarismlib.php');
require_once($CFG->dirroot . '/lib/outputrenderers.php');
require_once($CFG->dirroot . '/mod/forum/lib.php');
require_once($CFG->dirroot . '/group/lib.php');

$PAGE->requires->jquery();
$PAGE->requires->string_for_js('editpdf', 'assignfeedback_editpdf');
$PAGE->requires->string_for_js('viewfeedbackonline', 'assignfeedback_editpdf');
$PAGE->requires->js('/blocks/ned_teacher_tools/js/popup.js');
$PAGE->requires->js('/blocks/ned_teacher_tools/js/quiz.js');
$PAGE->requires->js('/blocks/ned_teacher_tools/js/fullscreen.js', true);

// It is necessary to hide blocks.
$PAGE->add_body_class('zoomin');

$PAGE->set_pagelayout('course');

user_preference_allow_ajax_update('block_ned_teacher_tools_zoom', PARAM_TEXT);
user_preference_allow_ajax_update('block_ned_teacher_tools_onlineeditor', PARAM_TEXT);
$hideblocks = get_user_preferences('block_ned_teacher_tools_zoom',  'nozoom');
$PAGE->add_body_class($hideblocks);

if (!$course = $DB->get_record("course", array("id" => $courseid))) {
    SH::print_error("Course ID was incorrect");
}

require_login($course);
// Grab course context.
$context = context_course::instance($course->id);
if (!$isteacher = has_capability('moodle/grade:viewall', $context)) {
    SH::print_error("Only teachers can use this page!");
}

$base_url = new moodle_url('/blocks/ned_teacher_tools/fn_gradebook.php',
    ['courseid' => $courseid, 'mid' => $mid, 'view' => $view, 'show' => $show, 'dir' => $dir,
        'participants' => $participants, 'activity_type' => $activitytype]
);
if (!is_null($show_inactive)){
    $base_url->param('show_inactive', $show_inactive);
}
if (!is_null($groupid)){
    $base_url->param('group', $groupid);
}

$show_inactive = NED\check_show_inactive_with_cache($show_inactive, $course->id);
list($allstudents, $groups) = block_ned_teacher_tools_get_users_and_groups($course, false, !$show_inactive);
$groupid = NED\check_group_with_cache($groupid, $course->id, $groups);
NED\set_cache_group($course->id, $groupid);
NED\set_cache_show_inactive($courseid, $show_inactive);
$students = NED\choose_students_by_group($allstudents, $groups, $groupid);
$SESSION->currentgroup[$courseid] = $groupid;


$keepseparate = 1; // Default value.
if ($blockconfig = block_ned_teacher_tools_get_block_config ($courseid)) {
    if (isset($blockconfig->keepseparate)) {
        $keepseparate = $blockconfig->keepseparate;
    }
}

$PAGE->set_url($base_url);
$PAGE->add_body_class('fn_gradebook-show-' . $show);

// Array of functions to call for grading purposes for modules.
$modgradesarray = block_ned_teacher_tools_supported_mods();

$gradingonly = false;
if (($action == 'submitgrade') && ($id)
    && !(optional_param('nosaveandprevious', null, PARAM_RAW))
    && !(optional_param('nosaveandnext', null, PARAM_RAW)) ) {
    $gradingonly = true;
    // Grade activity first.
    if (! $cmfograding = get_coursemodule_from_id('', $id)) {
        SH::print_error("Course Module ID was incorrect");
    }
    $selectedfunction = $modgradesarray[$cmfograding->modname];
    if (!empty($selectedfunction)) {
        $iid = $cmfograding->instance;
        include($selectedfunction);

        if (!$mid) {
            $mid = 0;
        }
    }
    $gradingonly = false;
    $action = 'submitgrade';
}

// Filter modules.
if ($activitytype) {
    $modgradesarray = isset($modgradesarray[$activitytype]) ? [$activitytype => $modgradesarray[$activitytype]] : [];
}

// Array of functions to call to display grades for modules.
$strgrades = get_string("headertitle", 'block_ned_teacher_tools');
$strmax = get_string("maximumshort");


// The sort options.
if ($show == 'marked') {
    $sortopts = array('lowest' => 'Lowest mark',
        'highest' => 'Highest mark',
        'date' => 'Submission date',
        'alpha' => 'Alphabetically');

    $url = new moodle_url($base_url);

    $sortform = 'Sort: ' . $OUTPUT->single_select($url->out(), 'sort', $sortopts, $selected = $sort, '', $formid = 'fnsort');
} else {
    $sortform = '';
    $sort = 'date';
}

// The view options.
$viewopts = array('less' => 'Less', 'more' => 'More');
$urlview = new moodle_url($base_url);
$select = new single_select($urlview, 'view', $viewopts, $selected = $view, '');
$select->label =  html_writer::img($OUTPUT->image_url('i/hide'), '');
$select->formid = 'fnview';
$viewform = '<div class="groupselector">'.$OUTPUT->render($select).'</div>';

// The show options.
if (($view == 'less') || ($view == 'more')) {
    if ($mid) {
        $cmmodule = $DB->get_record('course_modules', array('id' => $mid));
        $modulename = $DB->get_field('modules', 'name', array('id' => $cmmodule->module));

        if ($modulename == 'forum') {
            $showopts = array(
                'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                'marked' => get_string('marked', 'block_ned_teacher_tools'),
                'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
            );
        } else if ($modulename == 'assignment') {
            $showopts = array(
                'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                'saved' => get_string('saved', 'block_ned_teacher_tools'),
                'marked' => get_string('marked', 'block_ned_teacher_tools'),
                'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
            );
        } else if ($modulename == 'journal') {
            $showopts = array(
                'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                'marked' => get_string('marked', 'block_ned_teacher_tools'),
                'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
            );
        } else if ($modulename == 'assign') {
            $assign = $DB->get_record('assign', array('id' => $cmmodule->instance));
            if ($assign->submissiondrafts) {
                $showopts = array(
                    'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                    'saved' => get_string('saved', 'block_ned_teacher_tools'),
                    'marked' => get_string('marked', 'block_ned_teacher_tools'),
                    'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
                );
            } else {
                $showopts = array(
                    'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                    'marked' => get_string('marked', 'block_ned_teacher_tools'),
                    'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
                );
            }
        } else if ($modulename == 'quiz') {
            $showopts = array(
                'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
                'marked' => get_string('marked', 'block_ned_teacher_tools'),
                'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
            );
        } else {
            $showopts = array();
        }
    } else {
        $showopts = array(
            'unmarked' => get_string('unmarked', 'block_ned_teacher_tools'),
            'saved' => get_string('saved', 'block_ned_teacher_tools'),
            'marked' => get_string('marked', 'block_ned_teacher_tools'),
            'unsubmitted' => get_string('unsubmitted', 'block_ned_teacher_tools')
        );
    }

    if (!$keepseparate) {
        if (isset($showopts['saved'])) {
            unset($showopts['saved']);
        }
    }

    if (!isset($showopts[$show])){
        $showopts[$show] = get_string($show, 'block_ned_teacher_tools');
    }

    $urlshow = new moodle_url($base_url);
    $showform = $OUTPUT->single_select($urlshow, 'show', $showopts, $selected = $show, '', $formid = 'fnshow');
}

if ($mid) {
    if (!$coursemodule = $DB->get_record('course_modules', array('id' => $mid))) {
        SH::print_error('invalidcoursemodule');
    }

    if (!$module = $DB->get_record('modules', array('id' => $coursemodule->module))) {
        SH::print_error('invalidcoursemodule');
    }
}
// Get current group members.
$groupmembers = groups_get_members_by_role($groupid, $courseid);

// Get a list of all students.
$show_participants = $students;

$columnhtml = array();  // Accumulate column html in this array.
$columnungraded = array(); // Accumulate column graded totals in this array.
$totungraded = 0;

$modinfo = get_fast_modinfo($courseid, $USER->id);
$activities = $modinfo->get_cms();

foreach ($activities as $mod){
    // Filter if individual user selected.
    if ($participants && $groupid) {
        // $participantsarr = get_enrolled_users($context, 'mod/assign:submit', $groupid, 'u.*', 'u.id');
        if (isset($groupmembers[5]->users[$participants])) {
            $students = array();
            $students[$participants] = $DB->get_record('user', array('id' => $participants));
        } else {
            $participants = 0;
            //$students = get_enrolled_users($context, 'mod/assign:submit', $groupid, 'u.*', 'u.id');
        }
    } else if ($participants && !$groupid) {
        $students = array();
        $students[$participants] = $DB->get_record('user', array('id' => $participants));
        //$participantsarr = get_enrolled_users($context, 'mod/assign:submit', $groupid, 'u.*', 'u.id');
    }

    // Don't count it if you can't see it.
    $mcontext = context_module::instance($mod->id);
    if (!$mod->visible && !has_capability('moodle/course:viewhiddenactivities', $mcontext)) {
        continue;
    }

    $instance = $DB->get_record($mod->modname, array("id" => $mod->instance));
    if (!((($mod->modname != 'forum') || (($instance->assessed > 0) && has_capability('mod/forum:rate', $mcontext)))
        && isset($modgradesarray[$mod->modname]))){
        continue;
    }

    $gradefunction = NED\get_grade_function($mod);
    $modgrades = new stdClass();
    if (!$gradefunction || !($modgrades->grades = $gradefunction($instance))) {
        $modgrades->grades = array();
    }

    // Store the number of ungraded entries for this group.
    if (is_array($modgrades->grades)) {
        $gradedarray = array_intersect(array_keys($students), array_keys($modgrades->grades));
        $numgraded = count($gradedarray);
        $numstudents = count($students);
        $ungradedfunction = 'block_ned_teacher_tools_' . $mod->modname . '_count_ungraded';
        if (function_exists($ungradedfunction)) {
            $extra = false;
            $summary = $ungradedfunction($instance->id, $gradedarray, $students, $show,
                $extra, $instance, $keepseparate);
            $ung = $summary[$show];
        } else if ($show == 'unmarked') {
            $ung = $numstudents - $numgraded;
            if (($action == 'submitgrade') && ($mid == $mod->id)) {
                --$ung;
            }
        } else if ($show == 'marked') {
            $ung = $numgraded;
            if (($action == 'submitgrade') && ($mid == $mod->id)) {
                ++$ung;
            }
        } else {
            $ung = $numstudents - $numgraded;
            if (($action == 'submitgrade') && ($mid == $mod->id)) {
                --$ung;
            }
        }

        $columnungraded[$mod->id] = $ung;
        $totungraded += $ung;
    } else {
        $columnungraded[$mod->id] = 0;
    }

    if (($mid == $mod->id) && (end($columnungraded) == 0)) {
        $mid = 0;
    }

    // If we haven't specifically selected a mid, look for the oldest ungraded one.
    if (($mid == 0) && !empty($ung)) {
        $oldestfunc = 'block_ned_teacher_tools_' . $mod->modname . '_oldest_ungraded';
        if (function_exists($oldestfunc)) {
            $told = $oldestfunc($mod->instance);
            if (empty($cold) || ($told < $cold)) {
                $cold = $told;
                $cmid = $mod->id;
                $mid = $mod->id;
                $selectedmod = $instance;
                $selectedfunction = $modgradesarray[$mod->modname];
                $cm = $mod;
            }
        } else {
            $mid = $mod->id;
        }
    }

    // Get the function for the selected mod.
    if ($mid == $mod->id) {
        $selectedmod = $instance;
        $selectedfunction = $modgradesarray[$mod->modname];
        $cm = $mod;
    }

    if (!empty($modgrades->maxgrade)) {
        if ($mod->visible) {
            $maxgrade = "$strmax: $modgrades->maxgrade";
            $maxgradehtml = "<BR>$strmax: $modgrades->maxgrade";
        } else {
            $maxgrade = "$strmax: $modgrades->maxgrade";
            $maxgradehtml = "<BR><FONT class=\"dimmed_text\">$strmax: $modgrades->maxgrade</FONT>";
        }
    } else {
        $maxgrade = "";
        $maxgradehtml = "";
    }

    $modurl = new moodle_url($base_url);
    $modurl->param('mid', $mod->id);
    $add_class = 'assignmentlist';
    if (!$mod->visible){
        $add_class .= ' dimmed';
    }
    $mod_icon = NED\img('icon', 'mod-icon', $mod->modname, ['height' => 20, 'width' => 20]);
    $mod_text = $mod_icon .' '. $mod->name;
    $add_params['title'] = $mod->name;
    $mod_link = NED\link($modurl, $mod_text, 'mod-link', $add_params);
    $columnhtml[$mod->id] = html_writer::div($mod_link, $add_class);
}

// Set mid to cmid if there wasn't a mid and there is a cmid.
if (empty($mid) && !empty($cmid)) {
    $mid = $cmid;
}

// Setup selection options.
$button = '';

// Check to see if groups are being used in this assignment.
if (!empty($cm)) {
    if ($groupmode = groups_get_activity_groupmode($cm)) {   // Groups are being used.
        $groupform = groups_print_activity_menu($cm, $CFG->wwwroot . '/blocks/ned_teacher_tools/' .
            "fn_gradebook.php?courseid=$courseid&mid=$mid&show=$show&sort=$sort&dir=$dir&mode=single&view=$view", true);
    } else {
        $currentgroup = false;
        $groupform = '';
    }
} else {
    $groupform = '';
}

// Print header.
$PAGE->navbar->add($strgrades);
$button = '<tr><td>' . $groupform . '&nbsp;&nbsp;</td>' .
    '<td style="padding-left:10em;">' . $sortform . '&nbsp;&nbsp;</td>' .
    '<td style="padding-left:10em;">' . $viewform . '</td>' .
    '</tr>';

$PAGE->set_title($strgrades);
$PAGE->set_heading($course->fullname . ': ' . $strgrades);

echo $OUTPUT->header();
echo NED\link(new moodle_url(NED\PLUGIN_URL . 'marking_manager.php', $pageparams), NED\str('gotonewmmpage'));

// ACTIVITY TYPES.
$activitytypeopts = array(
    '0' => get_string('allactivitytypes', 'block_ned_teacher_tools'),
    'assign' => 'Assignments',
    'forum' => 'Forums',
    'journal' => 'Journal',
    'quiz' => 'Quizzes',
);
$activitytypeurl = new moodle_url($base_url);
$activitytypeselect = new single_select($activitytypeurl, 'activity_type', $activitytypeopts, $activitytype, '');
$activitytypeselect->formid = 'fn_activity_type';
$activitytypeselect->label =  html_writer::img($OUTPUT->image_url('i/preview'), '');
$activitytypeform = '<div class="groupselector">'.$OUTPUT->render($activitytypeselect).'</div>';

// PARTICIPANTS.
$participantsopts = array('0' => get_string('allparticipants', 'block_ned_teacher_tools'),);
$show_student_selector = !empty($show_participants);
if ($show_student_selector){
    foreach ($show_participants as $student) {
        $participantsopts[$student->id] = fullname($student);
    }
    $participantsurl = new moodle_url($base_url);
    $participantsform = block_ned_teacher_tools_groups_menu($participantsurl, 'participants', $participantsopts, $participants, 'fn_participants');
}

echo '<div id="marking-interface">';

echo '<div class="ned-teacher_tools-menu-wrapper">';

$groupurl = new moodle_url($base_url);
block_ned_teacher_tools_groups_print_course_menu($course, $groupurl, false, $groupid, $groups);
echo MB::show_inactive_checkbox($base_url, $show_inactive);
echo "&nbsp;&nbsp;";
if ($show_student_selector){
    echo $participantsform . "&nbsp;&nbsp;";
    echo $activitytypeform . "&nbsp;&nbsp;";
    echo $viewform . " ";
}
echo '</div>';

//echo '<table class="block" border="0" cellpadding="5" cellspacing="0" style="margin: auto;"><tr><td>';

$showtopmessage = get_config('block_ned_teacher_tools', 'showtopmessage');
$topmessage     = get_config('block_ned_teacher_tools', 'topmessage');

$blockconfig = new stdClass();

if ($blockinstance = $DB->get_record('block_instances', array('blockname' => 'ned_teacher_tools', 'parentcontextid' => $context->id))) {
    if (!empty($blockinstance->configdata)) {
        $blockconfig = unserialize(base64_decode($blockinstance->configdata));
    }
}

if (isset($blockconfig->showtopmessage) && isset($blockconfig->topmessage['text'])) {
    if ($blockconfig->showtopmessage && $blockconfig->topmessage['text']) {
        echo '<div id="marking-topmessage">'.$blockconfig->topmessage['text'].'</div>';

    } else if ($showtopmessage && $topmessage) {
        echo '<div id="marking-topmessage"><?php echo $topmessage; ?></div>';
    }
} else if ($showtopmessage && $topmessage) {
    echo '<div id="marking-topmessage">'.$topmessage.'</div>';
}

// No course average calculation.
$nocorseaveragemsg = '';
if ($gradeitem = $DB->get_record('grade_items', array('courseid' => $courseid, 'itemtype' => 'course'))) {
    if ($gradeitem->gradetype == GRADE_TYPE_NONE) {
        $nocorseaveragemsg = '<div class="course-average-warning"><img class="actionicon" width="16" height="16" alt="" src="'.
            $OUTPUT->image_url('i/risk_xss', '').'"> '.get_string('nocoursetotal', 'block_fn_mentor').'<div>';
    }
}
echo html_writer::start_div('markingmanagercontainer');
$fnmarkingblock = new html_table();
$fnmarkingblock->attributes['class'] = 'fnmarkingblock';
$t_head = html_writer::div('Marking Status', 'topline');

if (!empty($showform)) {
    $t_head .= html_writer::div($showform, 'bottomline');
    $fnmarkingblock->head[] = $showform;
}
$fnmarkingblock->head = [html_writer::div($t_head), ''];

foreach ($columnhtml as $index => $column) {
    if ($index == $mid) {
        $row_class = 'highlight';
    } else {
        $row_class = 'normal';
    }

    if ($index == $mid && $action == 'submitgrade' && !isset($_POST['nosaveandnext']) && !isset($_POST['nosaveandprevious'])) {
        if ($show <> 'marked') {
            $columnungraded[$index]--;
            $totungraded--;
        }
    }

    if ($columnungraded[$index] < 0.1 && $view == 'less') {
        continue;
    }
    $fnmarkingblock->data[] = NED\row([$columnungraded[$index], $column], $row_class);
};

$fnmarkingblock->data[] = NED\row([$totungraded, "Total {$showopts[$show]}"], 'marking-total');
echo html_writer::div(html_writer::table($fnmarkingblock), 'marking-status');
echo $nocorseaveragemsg;
echo html_writer::start_div('marking-main');

if (!isset($selectedmod)) {
    $selectedfunction = null;
}
if (!empty($selectedfunction)) {
    $iid = $selectedmod->id;
    include($selectedfunction);
    echo $o;
} else {
    echo '<div class="no-assign">No selected assignment</div>';
}
echo html_writer::end_div();
$pluginman = core_plugin_manager::instance();
$pluginfo = $pluginman->get_plugin_info('block_ned_teacher_tools');
echo html_writer::end_div();
echo block_ned_teacher_tools_footer();
echo html_writer::end_div();
echo $OUTPUT->footer($course);