<?php

use block_ned_teacher_tools\shared_lib as SH;

require_once('../../config.php');
require_once (__DIR__ .'/lib.php');

$courseid = required_param('id', PARAM_INT); // Course ID.
$url = SH::url('~manage_activities_settings.php', ['id' => $courseid]);
$course = SH::get_course($courseid);

if (!$course) {
    SH::print_error(get_string('incorrectcourseid', 'grades'));
}

require_login($course); // Sets up $COURSE and therefore the theme.
$context = SH::ctx($courseid);

// Permission.
if (!SH::has_capability('manageactivitiessettings', $context)) {
    SH::print_error(SH::str('permissionerror'));
}

$PAGE->set_pagelayout('course');
$PAGE->add_body_class('zoomin');
$PAGE->set_url($url);

$page_title = SH::str('manage_activities_settings');
$PAGE->navbar->add($page_title, new moodle_url(''));
$PAGE->set_title($page_title);
$PAGE->set_heading($course->fullname . ' - ' . $page_title);

$mform = new block_ned_teacher_tools\form\manage_activities_settings($course, $url);
if ($mform->is_cancelled()){
    redirect($url);
} elseif ($mform->save_data()){
    SH::redirect($url, SH::str('savedsuccessfully'), null,SH::NOTIFY_SUCCESS);
};

echo $OUTPUT->header();
echo $mform->draw();
echo $OUTPUT->footer($course);
