<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools as NED;
use \local_ned_controller\marking_manager\marking_manager as MM;
use block_ned_teacher_tools\output\menu_bar as MB;
use block_ned_teacher_tools\shared_lib as SH;

require_once('../../config.php');
require_once(__DIR__ . '/lib.php');
require_once($CFG->dirroot . '/course/lib.php');
require_once($CFG->dirroot . '/lib/plagiarismlib.php');
require_once($CFG->dirroot . '/lib/outputrenderers.php');
require_once($CFG->dirroot . '/mod/forum/lib.php');
require_once($CFG->dirroot . '/group/lib.php');

$id = optional_param('id', 0, PARAM_INT); // Mod id to look at.
$mid = optional_param(MM::P_MID, 0, PARAM_INT); // Mod id to look at.
$cmid = 0;                                 // If no mid is specified, we'll select one in this variable.

// From mod grade files.
$dir = optional_param('dir', 'DESC', PARAM_ALPHA);
$timenow = optional_param('timenow', 0, PARAM_INT);
$action = optional_param('action', '', PARAM_ALPHA);

// Paging options.
$page = optional_param('page', 0, PARAM_INT);
$perpage = optional_param('perpage', 20, PARAM_INT);

// Filtering Options.
$menushow = optional_param('menushow', 'unmarked', PARAM_ALPHA);
$sort = optional_param('sort', 'date', PARAM_ALPHANUM);
$show = optional_param(MM::P_STATUS, MM::ST_UNMARKED, PARAM_TEXT);
$view = optional_param(MM::P_VIEW, MM::VIEW_LESS, PARAM_TEXT);

$expand = optional_param('expand', 0, PARAM_INT);
$rownum = optional_param('rownum', 0, PARAM_INT);

$activitytype = optional_param(MM::P_ACTIVITY_TYPE, MM::MOD_ALL, PARAM_TEXT);
$participants = optional_param(MM::P_PARTICIPANTS, '0', PARAM_INT);
//$show_kica_activities = optional_param(MM::P_KICA_ACTIVITIES, 0, PARAM_INT);

//$deadline = optional_param(MM::P_DEADLINE, 0, PARAM_INT);
$get_show = optional_param(MM::P_GETSHOW, false, PARAM_BOOL);

$nosaveandprevious = optional_param('nosaveandprevious', null, PARAM_RAW);
$nosaveandnext = optional_param('nosaveandnext', null, PARAM_RAW);
$assign_grader = optional_param(MM::P_ASSIGN_GRADER, false, PARAM_BOOL);

// The view options.
$viewopts = SH::strings2menu(MM::VIEW_OPTIONS, true);
$view = NED\isset_key($viewopts, $view);
$view_more = $view == MM::VIEW_MORE;

$activitytypeopts = SH::strings2menu(MM::SELECT_MOD, true, '&nbsp;&nbsp;');
$show = NED\isset_in_list(MM::MM_SELECT_STATUS, $show);

if ($view_more){
    $activitytype = NED\isset_key($activitytypeopts, $activitytype);
} else {
    $activitytype = MM::MOD_ALL;
}
$mod_type = $activitytype;

$deadline_options = MM::get_deadline_options();
if ($show == MM::ST_WAITING_ZERO){
    $deadline = MM::get_deadline_value([MM::DEADLINE_PAST => 1]);
//    $deadline_selector_attr = ['disabled' => true];
} else {
    $deadline = NED\isset_key($deadline_options, $deadline ?? null);
//    $deadline_selector_attr = [];
}

// Page header
$pageparams = array(
    MM::P_MID => $mid,
    'dir' => $dir,
    'timenow' => $timenow,
    'action' => $action,
//    'expand' => $expand,
    'activity_type' => $activitytype,
    'rownum' => $rownum,
    'page' => $page,
    'perpage' => $perpage,
    'menushow' => $menushow,
    'sort' => $sort,
    MM::P_VIEW => $view,
    MM::P_STATUS => $show,
    MM::P_PARTICIPANTS => $participants,
//    MM::P_KICA_ACTIVITIES => $show_kica_activities,
//    MM::P_DEADLINE => $deadline,
);
if ($assign_grader){
    $pageparams['expand'] = $expand;
    $pageparams[MM::P_ASSIGN_GRADER] = $assign_grader;
    if ($show == MM::ST_ALL){
        $get_show = true;
    }
}
$pageparams2 = $pageparams;
unset($pageparams2['action']);

$MB = new MB(MB::PAGE_MM, $pageparams2);
$MB->show_error_for_not_teacher();

$courseid = $MB->courseid;
$course = $MB->course;
$groupid = $MB->groupid;
$students = $MB->students;
$allusers = $MB->allstudents;
$user = $MB->user;
$show_inactive = $MB->show_inactive;
$context = $MB->context;
$base_url = $MB->get_url();
$tag_id = $MB->tag_id;
$gradingonly = false;

$hide_cta = \block_ned_teacher_tools\cta_tracker::is_tracker_on($courseid);

if ($get_show && $mid && ($user->id ?? 0)){
    $MM = MM::get_MM_by_params($MB->parameters_for_MM(['type' => $mod_type]));
    $filter = MM::SELECT_STATUS;
    $filter[] = MM::SUM;
    $filter[MM::COURSEMODULE_IDS] = $mid;
    $filter[MM::P_MID] = $mid;
    if ($hide_cta){
        $filter[MM::TAG_NAME_LIST_HAVE_NONE] = [SH::TAG_CTA];
    }
    $MM->filter_hide_grades_before_midn_if_need($filter);
    $mm_data = $MM->get_data_all($filter);
    $show = null;
    foreach (MM::SELECT_STATUS as $status){
        if ($mm_data->$status ?? 0){
            $show = $status;
            break;
        }
    }

    $show = $show ?: MM::ST_ALL;
    $MB->set_pageparam(MM::P_STATUS, $show);
}

$pageparams = $MB->pageparams;
$pageparams['group'] = $groupid;

$PAGE->set_url($base_url);
$PAGE->add_body_class('marking-manager fn_gradebook-show-' . $show);

if ($assign_grader){
    if ($action == 'submitgrade' && $id && !$nosaveandprevious && !$nosaveandnext ) {
        $gradingonly = true;
    }
    $PAGE->add_body_class(MM::P_ASSIGN_GRADER);
    $PAGE->set_pagelayout('popup');
    $cm = SH::get_cm_by_cmid($mid, $courseid);
    $iid = $cm->instance;
    echo $OUTPUT->header();
    include(NED\PLUGIN_PATH.'/assign.submissions.fn.php');
    echo $o;
    echo $OUTPUT->footer($course);
    die;
}

$title = NED\str('markingmanager');
$PAGE->navbar->add($title);
$PAGE->set_title($course->shortname . ': ' . $title);
$PAGE->set_heading($course->fullname . ': ' . $title);
// js
$PAGE->requires->jquery();
$PAGE->requires->js('/blocks/ned_teacher_tools/js/popup.js');

if($show == MM::ST_UNMARKED || ($expand && $show == MM::ST_MARKED)){
    $PAGE->requires->js('/blocks/ned_teacher_tools/js/fullscreen.js', true);
    $PAGE->requires->string_for_js('editpdf', 'assignfeedback_editpdf');
    $PAGE->requires->string_for_js('viewfeedbackonline', 'assignfeedback_editpdf');
    $PAGE->requires->js_call_amd(NED\PLUGIN_NAME . '/marking_manager_unmarked', 'init');
}

if(($activitytype == MM::MOD_ALL || $activitytype == MM::MOD_ASSIGN) && $show == MM::ST_MARKED){
    $texts = ['loading', 'externalmodal'];
    $texts_processed = [];
    foreach ($texts as $text){
        $texts_processed[$text] = NED\str($text);
    }
    $texts_processed['title'] = $title . ': ' . NED\str(MM::P_ASSIGN_GRADER);

    $data = [MM::P_ASSIGN_GRADER, $texts_processed];
    $PAGE->requires->js_call_amd(NED\PLUGIN_NAME . '/marking_manager_assign_grader', 'init', $data);
}

echo $OUTPUT->header();

// No course average calculation.
$nocorseaveragemsg = '';
if ($gradeitem = $DB->get_record('grade_items', ['courseid' => $courseid, 'itemtype' => 'course'])) {
    if ($gradeitem->gradetype == GRADE_TYPE_NONE) {
        $nocorseaveragemsg = html_writer::div(NED\img('i/risk_xss', 'actionicon', ['width' => 16, 'height' => 16]) .
            get_string('nocoursetotal', 'block_fn_mentor'),
            'course-average-warning'
        );
    }
}

$showtopmessage = get_config('block_ned_teacher_tools', 'showtopmessage');
$topmessage     = get_config('block_ned_teacher_tools', 'topmessage');
$blockconfig = SH::get_site_and_course_block_config($courseid, SH::TT_NAME);

$out = [];
$MM = MM::get_MM_by_params($MB->parameters_for_MM(['type' => $mod_type]));
$cms = SH::get_important_activities_for_users($courseid, $students, true);
$cm_keys = array_keys($cms);
$use_deadline = MM::is_using_deadlines($show);

////////////////////
// Array of functions to call for grading purposes for modules.
$modgradesarray = block_ned_teacher_tools_supported_mods();

if ($action == 'submitgrade' && $id && !$nosaveandprevious && !$nosaveandnext ) {
    $gradingonly = true;
    // Grade activity first.
    if (! $cmfograding = get_coursemodule_from_id('', $id)) {
        SH::print_error("Course Module ID was incorrect");
    }
    $selectedfunction = $modgradesarray[$cmfograding->modname];
    if (!empty($selectedfunction)) {
        $iid = $cmfograding->instance;
        include($selectedfunction);

        if (!$mid) {
            $mid = 0;
        }
    }
    $gradingonly = false;
    $action = 'submitgrade';
}

// Filter modules.
if ($activitytype != MM::MOD_ALL) {
    $modgradesarray = isset($modgradesarray[$activitytype]) ? [$activitytype => $modgradesarray[$activitytype]] : [];
}
////////////////////
$show_student_selector = !empty($students);
$menu_wrapper_div = [];
// $menu_wrapper has reverse display
if ($show_student_selector){
    $menu_wrapper = [];
    // kica activities checkbox
    /*
    if ($MM->has_kica){
        $menu_wrapper[] = block_ned_teacher_tools_render_kica_activities_checkbox($show_kica_activities, $base_url, MM::P_KICA_ACTIVITIES);
    }
    */
    // deadline
    /*
    if ($use_deadline){
        $menu_wrapper[] = NED\single_select($base_url, MM::P_DEADLINE, $deadline_options, $deadline, NED\str('duedate'),
            null, null, $deadline_selector_attr);
    }
    */
    // view-select (less/more)
    $menu_wrapper[] = NED\single_select($base_url, MM::P_VIEW, $viewopts, $view, '');
    // tag-selector
    $menu_wrapper[] = $MB->render_tag_selector();
    // activitytype-select
    if ($view_more){
        $menu_wrapper[] = NED\single_select($base_url, MM::P_ACTIVITY_TYPE, $activitytypeopts, $activitytype, NED\img('i/preview'));
    }

    $menu_wrapper_div = [];
    foreach ($menu_wrapper as $key => $mw){
        $add_class = ['mm-selector'];
        if (!is_int($key)){
            $add_class[] = $key;
        }
        $menu_wrapper_div[] = html_writer::div($mw, join(' ', $add_class));
    }

    // status-select
    $menu_wrapper_div[] = $MM->get_status_selector($show, $view_more, $cm_keys);
}

$filter = [
    MM::NOT_ZERO,
    MM::CHECK_TAG => $tag_id,
    MM::USE_KICA,
    MM::CMIDS => $cm_keys,
    $show
];
if ($hide_cta){
    $filter[MM::TAG_NAME_LIST_HAVE_NONE] = [SH::TAG_CTA];
}
$MM->filter_hide_grades_before_midn_if_need($filter);

if ($show != MM::ST_UNMARKED_MISSED_DEADLINE){
    $filter[] = MM::COUNT_UNMARKED_MISSED_DEADLINE;
}

if ($show != MM::ST_DRAFT && SH::$C::has_capability('editothersubmission', SH::ctx($courseid, $mid))){
    $filter[] = MM::COUNT_DRAFT;
}

if ($use_deadline){
    $filter[MM::DEADLINE] = $deadline;
}

if (!empty($blockconfig->excludewithoutsla)){
    $filter[MM::TAG_NAME_LIST_HAVE_ANY] = SH::SLA_TAGS;
}

// get mm_data and render status-block
$fnmarkingblock = $MM->render_mm_status($filter, $show, $mid, $base_url);
$out[] =  html_writer::div(join('', $menu_wrapper_div), 'mm-menu-wrapper');
$out[] = html_writer::start_div('markingmanagercontainer');
$cm = null;

if ($fnmarkingblock){
    if (isset($blockconfig->showtopmessage) && isset($blockconfig->topmessage['text'])){
        $showtopmessage = $blockconfig->showtopmessage;
        $topmessage = $blockconfig->topmessage['text'];
    }

    if ($showtopmessage && $topmessage){
        $out[] = html_writer::div($topmessage, '', ['id' => 'marking-topmessage']);
    }

    $out[] = html_writer::div(html_writer::table($fnmarkingblock), 'marking-status');
    $out[] = $nocorseaveragemsg;

    $o = $MM->render_by_show();
    if (is_null($o)){

        if ($MM->cm){
            $cm = $MM->cm;
            $selectedmod = $DB->get_record($cm->modname, ['id' => $cm->instance]);
            $selectedfunction = $modgradesarray[$cm->modname] ?? null;
        }

        $grade_item = \grade_item::fetch_all(['courseid' => $cm->course, 'itemtype' => 'mod',
            'iteminstance' => $cm->instance, 'itemmodule' => $cm->modname]);
        if($grade_item){
            $grade_item = reset($grade_item);
            $gradebookurl = new moodle_url('/grade/report/singleview/index.php',
                ['id' => $MB->courseid, 'item' => 'grade', 'group' => $MB->groupid, 'itemid' => $grade_item->id]
            );
            $opengradereport_link = html_writer::link($gradebookurl, NED\str('overrideexclude'),
                ['id' => 'open-grade-report-link', 'target' => '_blank']);
        }
        if (!isset($selectedmod)) {
            $selectedfunction = null;
        }
        if (!empty($selectedfunction)) {
            $iid = $selectedmod->id;
            include($selectedfunction); // get $o
        } else {
            $o = html_writer::div(NED\str('noselectedactivities'), 'no-selected');
        }

        $o = $MM->render_activity_header() . $o;
    }

    $out[] = html_writer::div($o, 'marking-main');
} else {
    $out[] = html_writer::div(NED\str('noactivities'), 'noactivities');
}

$out[] = html_writer::end_div();
$out[] = block_ned_teacher_tools_footer();

$renderer = $PAGE->get_renderer('block_ned_teacher_tools');
echo $renderer->render($MB);
echo html_writer::div(join('', $out), '', ['id' => 'marking-interface']);
echo $OUTPUT->footer($course);
