<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;

require_once($CFG->dirroot . '/blocks/ned_teacher_tools/lib.php');
require_once($CFG->dirroot . '/blocks/ned_teacher_tools/common_lib.php');

// Useful functions
$plugin = 'block_ned_teacher_tools';

$check_str = function($identifier, $def=null, $args=null) use ($plugin){
    if (!is_string($identifier)){
        return $identifier;
    }

    return SH::str_check($identifier, $args, $def, $plugin);
};

$help_str = function($name, $visiblename='', $description='', $defaultsetting='') use ($plugin, $check_str){
    $visiblename = empty($visiblename) ? $name : $visiblename;
    $description = empty($description) ? $check_str($visiblename . '_desc', '') : $check_str($description);
    $name = $plugin . '/' . $name;
    return [$name, $check_str($visiblename), $description, $check_str($defaultsetting)];
};

$get_link = function($t_url='', $text='', $param_url=[], $attr=['target' => '_blank']) use ($plugin){
    $m_url = new moodle_url($t_url, $param_url);
    if (!empty($text)) {
        if (get_string_manager()->string_exists($text, $plugin)){
           $text = NED\str($text);
        }
    } else {
       $text = $t_url;
    }
    return html_writer::link($m_url, $text, $attr);
};

$configheading = function($name, $heading='', $information=null) use ($plugin, $check_str){
    $heading = empty($heading) ? $name : $heading;
    $information = is_null($information) ? $heading . '_info' : $information;
    return new admin_setting_heading($plugin . '/' . $name, $check_str($heading),$check_str($information, ''));
};
$configempty = function($name, $visiblename, $description=null) use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description);
    return new admin_setting_configempty($name, $visiblename, $description);
};
$configtext = function($name, $visiblename, $description=null, $defaultsetting='', $paramtype=PARAM_RAW, $size=null) use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_configtext($name, $visiblename, $description, $defaultsetting, $paramtype, $size);
};
$configtext2 = function($name, $defaultsetting='', $paramtype=PARAM_RAW, $size=null, $visiblename='', $description=null) use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_configtext($name, $visiblename, $description, $defaultsetting, $paramtype, $size);
};
$configselect = function($name, $visiblename='', $description='', $defaultsetting=0, $choices=[]) use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_configselect($name, $visiblename, $description, $defaultsetting, $choices);
};
$configselect2 = function($name, $defaultsetting=0, $choices=[], $visiblename='', $description='') use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_configselect($name, $visiblename, $description, $defaultsetting, $choices);
};

$configmultiselect = function($name, $visiblename='', $description='', $defaultsetting=[], $choices=[]) use ($help_str){
    list($name, $visiblename, $description, $a) = $help_str($name, $visiblename, $description, '');
    return new admin_setting_configmultiselect($name, $visiblename, $description, $defaultsetting, $choices);
};
$configmultiselect2 = function($name, $choices=[], $defaultsetting=[], $visiblename='', $description='') use ($help_str){
    list($name, $visiblename, $description, $a) = $help_str($name, $visiblename, $description, '');
    return new admin_setting_configmultiselect($name, $visiblename, $description, $defaultsetting, $choices);
};

$yesnooptions = ['0' => get_string('no'), '1' => get_string('yes')];
$configyesno = function($name, $defaultsetting=0, $visiblename='', $description='') use ($configselect, $yesnooptions){
    return $configselect($name, $visiblename, $description, $defaultsetting, $yesnooptions);
};
$showhideoptions = ['0' => get_string('hide'), '1' => get_string('show')];
$configshowhide = function($name, $defaultsetting=0, $visiblename='', $description='') use ($configselect, $showhideoptions){
    return $configselect($name, $visiblename, $description, $defaultsetting, $showhideoptions);
};

$confightmleditor = function($name, $visiblename, $description=null, $defaultsetting='', $paramtype=PARAM_RAW, $cols='60', $rows='8') use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_confightmleditor($name, $visiblename, $description, $defaultsetting, $paramtype, $cols, $rows);
};

$configtextarea = function($name, $visiblename, $description=null, $defaultsetting='', $paramtype=PARAM_RAW, $cols='60', $rows='8')
use ($help_str){
    list($name, $visiblename, $description, $defaultsetting) = $help_str($name, $visiblename, $description, $defaultsetting);
    return new admin_setting_configtextarea($name, $visiblename, $description, $defaultsetting, $paramtype, $cols, $rows);
};

// Useful block links
$settings->add($configheading('blocklinks'));

// Link: Block Info
$settings->add($configempty('blockinfo', 'blockinfo',
    $get_link('/local/ned_controller/index.php', get_string('pluginname', 'local_ned_controller')))
);
// Link: Unused resubmissions manager
$settings->add($configempty('unused_resubmissions_manager',
    '',
    $get_link('/blocks/ned_teacher_tools/unused_resubmissions_manager.php', 'unused_resubmissions_manager'))
);
// Link: Grading Monitor
$settings->add($configempty('gradingtracker_page',
        '',
        $get_link('/blocks/ned_teacher_tools/grading_tracker.php', 'gradingtracker'))
);
// Link: Update scripts
$settings->add($configempty('updatescripts', 'updatescripts',
    $get_link('/blocks/ned_teacher_tools/update_scripts.php','updatescripts'))
);
// Link: Activity Bulk Settings Changer
$settings->add($configempty('activitybulksettingschanger', 'activitybulksettingschanger',
    $get_link('/blocks/ned_teacher_tools/activity_settings_changer.php','activitybulksettingschanger'))
);

// some general data
$list100 = range(0,100);
unset($list100[0]);

$tagcollid = core_tag_area::get_collection('core', 'course_modules');
$namefield = empty($CFG->keeptagnamecase) ? 'name' : 'rawname';
$cm_tags = $DB->get_records_menu('tag', ['isstandard' => 1, 'tagcollid' => $tagcollid], $namefield, 'id,' . $namefield);

$categorieslist = \core_course_category::make_categories_list() ?: [];
$categorieslist = ['0' => get_string('all')] + $categorieslist;
foreach ($categorieslist as &$cat){
    $cat = str_replace('&amp;', '&', $cat);
}

// Progress Report.
$settings->add($configheading('progressreport'));
$passgradeoptions = array(
    NED\ACTIVITYSETTING => NED\str('useactivitysetting'),
    NED\PASSGRADEPERCENT => NED\str('usepassgradepercent'),
);
$settings->add($configselect2('passgrade',NED\ACTIVITYSETTING, $passgradeoptions));
$settings->add($configtext('passgradepercent','','',50,PARAM_INT));

// Resubmissions
$settings->add($configheading('resubmissions'));
$settings->add($configyesno('enableresubmissions',0));
$settings->add($configselect2('resubmissioncriteria',0,
    [0 => NED\str('none'), 1 => NED\str('participationpower')]));
$settings->add($configtext('participationpowerrequired','','',100,PARAM_INT));
$settings->hide_if("$plugin/participationpowerrequired", "$plugin/resubmissioncriteria", 'neq', 1);
$settings->add($configtext('maximumattemptsincourse','','zeroisinfinity',2,PARAM_INT));
$settings->add($configtext('maximumattempts','','zeroisinfinity',1,PARAM_INT));
$settings->add($configtext('daysforresubmission','','zeroisinfinity',2,PARAM_INT));


// General Settings.
$settings->add($configheading('generalsettings'));
$settings->add($configyesno('include_orphaned', 0));
$settings->add(
    $configselect2('suspendeduserstoshow',0,
        [
            '0' => NED\str('none'),
            '1' => NED\str('suspendedenrollments'),
            '2' => NED\str('suspendedusers'),
            '3' => NED\str('both')
        ]
    )
);

$settings->add($configshowhide('editortoggle',0));

// Layout and format.
$settings->add($configtext('blocktitlecourselevel','','','teachertools',PARAM_TEXT));

$settings->add($configshowhide('showcourselink', 0));
$settings->add($configshowhide('showtitles',1));

$truncateactivitynameoptions = range(0,5);
$truncateactivitynameoptions[0] = get_string('default');
$settings->add($configselect2('truncateactivitynames',0, $truncateactivitynameoptions));

// Cronjobs
$settings->add($configheading('cronjobs'));
if (SH::ctrl_server_is_maple()){
    $str_no = $yesnooptions[0];
    $settings->add($configempty('crongt_maple_option', 'crongt_maple_option',
        SH::notification('crongt_maple_warning', SH::NOTIFY_WARNING, false))
    );
    $settings->add($configempty('crongt_enable', 'crongt_enable', $str_no));
    $settings->add($configempty('crongt_notify_enable', 'crongt_notify_enable', $str_no));
} else {
    $settings->add($configyesno('crongt_enable', 1));
    $hours = range(0,23);
    $settings->add($configselect('crongt_hour', '', '', 10, $hours));
    $settings->add($configtext('crongt_runtime', '', '', 45, PARAM_INT));
    $settings->add($configtext('crongt_delay', '', '', 10, PARAM_INT));
    $settings->add($configyesno('crongt_notify_enable', 1));
    $settings->add($configselect('crongt_notify_hour', '', '', 3, $hours));
}

// NED Teacher Tools.
$settings->add($configheading('markingmanager'));
$settings->add($configshowhide('showunmarked',1));
$settings->add($configshowhide('showmarked',1));
$settings->add($configshowhide('showunsubmitted',1));
$settings->add($configshowhide('showdraft',0));
$settings->add($configyesno('excludewithoutsla',0));

// Quick links.
$settings->add($configheading('quicklinks'));
$settings->add($configshowhide('showgradeslink',1));
$settings->add($configshowhide('showactivitycompletions',1));
$settings->add($configshowhide('showgradebook',1));
$gradebookoptions = array(
    '0' => NED\str('moodle'),
    '1' => NED\str('kica'),
    '2' => NED\str('both'),
);
$settings->add($configselect2('gradebooklink',1, $gradebookoptions));
$settings->add($configyesno('replacewithkicagrade', 1));
$settings->add($configshowhide('showreportslink',1));

// Custom links.
$settings->add($configheading('customlinks'));
$settings->add($configtext('customlinkstitle','','','courseresources'));

$numberoflinksoptions = range(0,10);
$settings->add($configselect2('numberoflinks',0, $numberoflinksoptions));
$settings->add($configempty('iconcoodes', 'iconcoodes',
        $get_link('http://fontawesome.io/icons/')));

$numberoflinks = get_config($plugin, 'numberoflinks');

$linkbehaviouroptions = array(
    '_blank' => NED\str('newwindow'),
    '_self' => NED\str('samewindow'),
    '_popup' => NED\str('popup')
);


if (!empty($numberoflinks)) {
    for ($i = 1; $i <= (int)$numberoflinks; $i++) {
        // Link.
        $settings->add($configheading('link'.$i, NED\str('link').' '.$i, ''));
        $settings->add($configtext('iconcode_'.$i, 'iconcode', '', 'fa-square-o'));
        $settings->add($configtext('customlinkstitle_'.$i, 'title', '', ''));
        $settings->add($configtext('customlinkurl_'.$i, 'link', '', '', PARAM_URL));
        $settings->add($configselect2('linkbehaviour_'.$i, '_self', $linkbehaviouroptions, 'linkbehaviour'));
        $settings->add($configyesno('showinstudentmenu_'.$i, 0, 'showinstudentmenu'));
    }
}


// Notices.
$settings->add($configheading('notices'));
$settings->add($configselect2('daysnotlogged',7, $list100));
$settings->add($configshowhide('showstudentnotsubmittedassignment',1));
$settings->add($configselect2('daysnotsubmited',7, $list100));

$settings->add($configshowhide('showstudentmarkslessthanfiftypercent', 1));
$settings->add($configselect2('setpercentmarks',50, $list100));

// Course Completion Status Controller
$settings->add($configheading('coursecompletionstatuscontroller'));
$settings->add($configyesno('enablecoursecompletionstatuscontroller',0));
$settings->add($configmultiselect2('coursecompletionstatuscontroller_coursecategories', $categorieslist));

// Grading Monitor
$settings->add($configheading('gradingtracker'));
$settings->add($configtext2('gradingtracker_startdate', '01/09/2021', '/\s*(\d?\d([\\\\]|[\/])){2}\d\d\d\d\s*/'));
$settings->add($configtext2('gradingtracker_statisticdate', '01/01/2021', '/\s*(\d?\d([\\\\]|[\/])){2}\d\d\d\d\s*/'));
$settings->add($configmultiselect2('gradingtracker_coursecategories', $categorieslist));
$settings->add($configtext2('gradingtracker_manystudents', '30, 50, 100', PARAM_TEXT));

if (!empty($cm_tags)){
    $settings->add($configmultiselect('gradingtracker_activitiestags3days','', '', [], $cm_tags));
    $settings->add($configmultiselect('gradingtracker_activitiestags5days','', '', [], $cm_tags));
}

$def_weekends = ['Canadian holiday'];
$settings->add($configtextarea('gradingtracker_weekend', '', '', join("\n", $def_weekends), PARAM_TEXT));

$def_postfixes = ['-N'];
$settings->add($configtext2('gradingtracker_deny_group_postfixes', join("; ", $def_postfixes), PARAM_TEXT));

// CTA
$menu_def = [-1 => get_string('none')];
$settings->add($configheading('ctatracker'));
/** @var grade_scale[] $scales */
$scales = grade_scale::fetch_all_global() ?: [];
$scale_options = $menu_def;
foreach ($scales as $scale){
    if (!$scale->is_hidden()){
        $scale_options[$scale->id] = $scale->get_name();
    }
}
$settings->add($configselect2('cta_scale',-1, $scale_options));

$role_ids = get_roles_for_contextlevels(CONTEXT_MODULE); // some_id => roleid
$where = [];
$params = [];
SH::sql_add_get_in_or_equal_options('id', $role_ids, $where, $params);
$role_objects = $DB->get_records_select('role', SH::sql_condition($where), $params);
$role_options = $menu_def + role_fix_names($role_objects, null, ROLENAME_ALIAS, true);
$settings->add($configselect2('cta_role',-1, $role_options));

// Other setting.
$settings->add($configheading('othersettings'));
$settings->add($configtext2('currentschoolyears', '', PARAM_TEXT, null, '', get_string('currentschoolyears_desc', 'block_ned_teacher_tools')));
$settings->add($configyesno('keepseparate',1));
$settings->add($configyesno('showtopmessage',0));
$settings->add($confightmleditor('topmessage','topmessage','',''));

// Deadline manager.
$settings->add($configyesno('syncdmenddateswithenrolment',1));
