<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\output\menu_bar as MB;

if (!isset($CFG)){
    require_once('../../config.php');
}
require_once($CFG->dirroot . '/blocks/ned_teacher_tools/lib.php');

$show = optional_param('show', 'all', PARAM_ALPHAEXT);
$fs_type = optional_param('fs_type', NED\USUAL_ACTIVITY, PARAM_INT);
$tag    = optional_param('tag', 0, PARAM_INT);


$MB = new MB(MB::PAGE_SP, ['show' => $show, 'fs_type' => $fs_type, 'tag' => $tag]);
$MB->show_error_for_not_teacher();
$course = $MB->course;
$groupid = $MB->groupid;
$enrolledusers = $MB->students;
$allusers = $MB->allstudents;
$user = $MB->user;
$base_moodle_url = $MB->get_url();

$renderer = $PAGE->get_renderer(NED\PLUGIN_NAME);
$extra = $renderer->render($MB);

$called_from_somewhere = $PAGE->has_set_url();
if (empty($allusers)) {
    if (!$called_from_somewhere){
        $title = NED\str('studentprogress');
        $PAGE->set_url($base_moodle_url);
        $PAGE->set_title($title);
        $PAGE->set_heading($course->fullname . ': ' . $title);
        echo $OUTPUT->header();
    }
    echo $OUTPUT->heading(get_string("nostudentsyet"));
    echo $extra;
    if (!$called_from_somewhere){
        echo $OUTPUT->footer($course);
        die;
    } else {
        return;
    }
}

if (empty($user) && !empty($enrolledusers)){
    $base_moodle_url->param(MB::PAR_USER, reset($enrolledusers)->id);
    redirect($base_moodle_url);
    die;
}

NED\render_student_progress_page($course, $user, $show, $fs_type, $groupid, $tag, '', $extra);
