<?php  // Moodle configuration file

define('SYSCONTEXTID', 1);
define('LASTACCESS_UPDATE_SECS', 600);

unset($CFG);
global $CFG;
$CFG = new stdClass();

$CFG->dbtype    = 'mariadb';
# $CFG->dblibrary = 'native';
$CFG->dbhost    = 'localhost';
$CFG->dbname    = 'mcb_rosedaleedu';
$CFG->dbuser    = 'mcb_rosedaleedu';
$CFG->dbpass    = 'zeiMei0eiM2phiec';
$CFG->prefix    = 'mdl_';
$CFG->dboptions = array (
  'dbpersist' => 0,
  'dbport' => 3306,
  'dbsocket' => '',
  'dbcollation' => 'utf8mb4_unicode_ci',
  'logslow'  => 40,
  'logerrors'  => true,
);

$CFG->wwwroot   = 'https://staging.ghs.rosedaleedu.com';
$CFG->dataroot  = '/home/outsource/staging.ghs.rosedaleedu.com/www/data/';
$CFG->admin     = 'admin';
$CFG->debugusers = '2';
$CFG->showcrondebugging = true;
$CFG->lock_factory = "\\core\\lock\\db_record_lock_factory";


if(file_exists(__DIR__ . '/calc_snap_time.php')) {
	include_once(__DIR__ . '/calc_snap_time.php');
	$CFG->messagebar = 'STAGING ENV: [GHS Live Server] copy dating [UTC ' . $snap_info . ']. WARNING: Changes to this site are permanent !';
}

$CFG->task_scheduled_concurrency_limit = 15; // Defaults to 3
$CFG->task_adhoc_concurrency_limit = 15; // Defaults to 3

$CFG->noemailever = true;    // NOT FOR PRODUCTION SERVERS!
$CFG->directorypermissions = 0777;

// Maple-View tasks - manually added on 16.03.2023 at Fern's request.
$CFG->ghs_report_disable_tasks = [
    //'adhoc_ghs_grades_report',
    'adhoc_ghs_sla_report',
    'adhoc_ghs_enrollment_report',
    'adhoc_ghs_group_enrollment_report',
    'adhoc_ghs_missed_grade_report',
    'adhoc_ghs_grade_comparisons_report',
    'adhoc_ghs_sla_export',
    'adhoc_ghs_enrollment_export',
    'adhoc_ghs_group_enrollment_export',
    'adhoc_ghs_missed_grade_export',
    'adhoc_ghs_grade_comparisons_export',
];

// Custom debug session
if (isset($_COOKIE['XDEBUG_SESSION'])){
    if ($_COOKIE['XDEBUG_SESSION'] == "PHPSTORM"){
        @error_reporting(E_ALL | E_STRICT);
        @ini_set('display_errors', '1');
        $CFG->debug = (E_ALL | E_STRICT);
        $CFG->debugdisplay = 1;
        $CFG->debugdeveloper = true;
        $CFG->debugdisplay = true;
        $CFG->perfdebug = 15;
        $CFG->debugpageinfo = true;
    }
}

require_once(__DIR__ . '/lib/setup.php');

// Custom exception and error handlers
$set_ned_handlers = function(){
    $def_exception_handler = null;
    $def_error_handler = null;
    $_handler = function($ex=null, $name='error'){
        global $CFG, $USER, $FULLME, $_SERVER;
        if (empty($ex)){
            return;
        }

        if (defined('CLI_SCRIPT') && CLI_SCRIPT){
            return;
        } elseif (defined('AJAX_SCRIPT') && AJAX_SCRIPT){
            return;
        }

        $error_msg = [];
        $error_msg[]= "Next $name called";
        $path = $CFG->wwwroot.'/?';
        if (function_exists('qualified_me')){
            $path = qualified_me();
        } elseif (isset($FULLME)){
            $path = $FULLME;
        } elseif (isset($_SERVER)){
            $path = ($_SERVER['HTTP_HOST'] ?? $CFG->wwwroot) . ($_SERVER['REQUEST_URI'] ?? '/??');
        }
        $error_msg[]= 'from '.$path;
        $userid = $USER->id ?? 0;
        $error_msg[]= "by user '$userid'";

        error_log(join(' ', $error_msg));
    };
    $exception_handler = function($ex) use (&$_handler, &$def_exception_handler){
        global $CFG, $USER;
        $show_exception = true;
        /**
         * @see default_exception_handler()
         */
        if (is_string($def_exception_handler) && $def_exception_handler == 'default_exception_handler'){
            if (($ex instanceof required_capability_exception) && !CLI_SCRIPT && !AJAX_SCRIPT &&
                !empty($CFG->autologinguests) && !empty($USER->autologinguest)){
                $show_exception = false;
            } elseif (function_exists('get_exception_info')) {
                $info = get_exception_info($ex);
                if (is_early_init($info->backtrace)){
                    $show_exception = false;
                }
            }
        }

        if ($show_exception){
            $_handler($ex, 'exception');
        }
        if ($def_exception_handler){
            return call_user_func($def_exception_handler, $ex);
        }
        return false;
    };
    $error_handler = function($errno, $errstr, $errfile, $errline) use (&$_handler, &$def_error_handler){
        $show_error = true;
        /**
         * @see default_error_handler()
         */
        if (is_string($def_error_handler) && $def_error_handler == 'default_error_handler'){
            if ($errno != 4096){
                $show_error = false;
            }
        }

        if ($show_error){
            $_handler($errno, 'error');
        }
        if ($def_error_handler){
            return call_user_func($def_error_handler, $errno, $errstr, $errfile, $errline);
        }
        return false;
    };

    $def_exception_handler = set_exception_handler($exception_handler);
    $def_error_handler = set_error_handler($error_handler, E_ALL | E_STRICT);
};
$set_ned_handlers();
unset($set_ned_handlers);

// There is no php closing tag in this file,
// it is intentional because it prevents trailing whitespace problems!

