<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    format_ned
 * @subpackage NED
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir.'/filelib.php');
require_once($CFG->libdir.'/completionlib.php');

// Horrible backwards compatible parameter aliasing....
if ($ctopic = optional_param('ctopics', 0, PARAM_INT)) { // Collapsed Topics old section parameter.
    $url = $PAGE->url;
    $url->param('section', $ctopic);
    debugging('Outdated collapsed topic param passed to course/view.php', DEBUG_DEVELOPER);
    redirect($url);
}
if ($topic = optional_param('topic', 0, PARAM_INT)) { // Topics and Grid old section parameter.
    $url = $PAGE->url;
    $url->param('section', $topic);
    debugging('Outdated topic / grid param passed to course/view.php', DEBUG_DEVELOPER);
    redirect($url);
}
if ($week = optional_param('week', 0, PARAM_INT)) { // Weeks old section parameter.
    $url = $PAGE->url;
    $url->param('section', $week);
    debugging('Outdated week param passed to course/view.php', DEBUG_DEVELOPER);
    redirect($url);
}
// End backwards-compatible aliasing....

$context = context_course::instance($course->id);
// Retrieve course format option fields and add them to the $course object.
$courseformat = course_get_format($course);
$formatdisplaysectionno = $courseformat->get_displaysection();
$deliverymethod = $courseformat->get_setting('sectiondeliverymethod');

if (!($section || $sectionid) && $deliverymethod && isset($deliverymethod->nedlandingpages) && $deliverymethod->nedlandingpages){
    $is_teacher = has_capability('moodle/grade:viewall', $context);
    $is_student = !$is_teacher && has_capability('mod/assignment:submit', $context);
    do {
        if ($is_teacher){
            $TT_config = get_config(format_ned::TT_name);
            if (!isset($TT_config->version) || $TT_config->version < format_ned::TT_version){
                break;
            }

            $deadline_manager_class_page = "$CFG->dirroot/blocks/ned_teacher_tools/classes/deadline_manager.php";
            $deadline_manager_page = "$CFG->dirroot/blocks/ned_teacher_tools/deadline_manager.php";
            if (!file_exists($deadline_manager_class_page) || !file_exists($deadline_manager_page)){
                break;
            }

            if (!block_ned_teacher_tools_has_deadline_capability($context)){
                break;
            }

            require_once($deadline_manager_class_page);
            list($enrolledusers, $groups) = block_ned_teacher_tools_get_users_and_groups($course, true);

            foreach ($groups as $groupid => $group){
                if($group->schedule != \block_ned_teacher_tools\deadline_manager::SCHEDULE_FULL){
                    unset($groups[$groupid]);
                }
            }

            if (empty($groups)){
                break;
            }

            $_POST['courseid'] = $course->id;
            if (count($groups) == 1){
                $_POST['group'] = reset($groups)->id;
            }

            require($deadline_manager_page);

        } elseif ($is_student){
            $SM_config = get_config(format_ned::SM_name);
            if (!isset($SM_config->version) || $SM_config->version < format_ned::SM_version){
                break;
            }

            $student_progress_page = "$CFG->dirroot/blocks/ned_student_menu/student_progress.php";
            if (!file_exists($student_progress_page)){
                break;
            }

            require($student_progress_page);

        } else {
            break;
        }

        return;
    } while (false);

    $formatdisplaysectionno = $formatdisplaysectionno ? $formatdisplaysectionno : 1;
}

if (!empty($formatdisplaysectionno)) {
    $url = $PAGE->url;
    $url->param('section', $formatdisplaysectionno);
    $PAGE->set_url($url);
    $displaysection = $formatdisplaysectionno;
}

$weareediting = $PAGE->user_is_editing();

$sectionformat = $courseformat->get_setting('sectionformat');
if ($sectionformat >= 1) { // Framed sections.
    global $DB;
    if ($sectionformat == 3) { // Framed sections + Formatted header.
        /* Build an array of sections with their colour preset value.  Any that are not '0', the
           Format / Theme Default, as set above will need to be specified here. */
        static $shfrows = array(1 => 'sectionheaderformatone', 2 => 'sectionheaderformattwo', 3 => 'sectionheaderformatthree');
        $sectionheaderformats = $courseformat->get_setting('sectionheaderformats');
        $sectioncolourpresets = array(); // Indexed by colour preset.
        $numsections = $courseformat->get_last_section_number();
        $sectionno = 1;
        while ($sectionno <= $numsections) {
            $sectionformat = $courseformat->get_setting('sectionheaderformat', $sectionno);
            $sectioncolourpreset = $sectionheaderformats[$shfrows[$sectionformat['headerformat']]]['colourpreset'];
            if ($sectioncolourpreset != 0) { // Not Format / Theme Default.
                $sectioncolourpresets[$sectioncolourpreset] = $sectioncolourpreset;
            }
            $sectionno++;
        }
        // We now have an array of colour presets (or none!) that tell us which sections have chosen them.
        if (!empty($sectioncolourpresets)) {
            echo '<style type="text/css" media="screen">';
            echo '/* <![CDATA[ */';

            foreach ($sectioncolourpresets as $presetno) {
                if ($presetno == 0) {
                    // Set to Format / Theme default so nothing to do.
                    continue;
                } else {
                    $sectionpreset = $DB->get_record('format_ned_colour', array('id' => $presetno));
                }
                /* Notes: If $sectionpreset is null then check that 'sectionheaderformats' in the 'course_format_options' table
                          in the database has not been corrupted and contains 'null's for the 'colourpreset'.
                          This can be caused by '$data[$shfrow.'colourpreset']' being 'null' in 'update_course_format_options()'
                          in lib.php.

                          li.colourpreset- is determined from section_header() and section_summary() in renderer.php.
                */

                if ($weareediting) {
                    echo 'ul.ned-framedsections li.colourpreset-'.$presetno.'.section.main .header,'.
                         'ul.ned-framedsections li.colourpreset-'.$presetno.'.section.main .footer {';
                } else {
                    echo 'ul.ned-framedsections li.colourpreset-'.$presetno.'.section.main {';
                }
                echo 'background-color: #'.$sectionpreset->framedsectionbgcolour.';';
                echo '}';

                if ($weareediting) {
                    echo 'ul.ned-framedsections li.colourpreset-'.$presetno.'.section.main .content {';
                    echo 'border-left-color: #'.$sectionpreset->framedsectionbgcolour.';';
                    echo 'border-right-color: #'.$sectionpreset->framedsectionbgcolour.';';
                    echo '}';
                }

                echo '.ned-framedsections li.colourpreset-'.$presetno.'.section .header {';
                echo 'color: #'.$sectionpreset->framedsectionheadertxtcolour.';';
                echo '}';

                echo 'body:not(.editing) .course-content ul.ned.ned-framedsections li.section.colourpreset-'.$presetno.' .left,'.
                     'body:not(.editing) .course-content ul.ned.ned-framedsections li.section.colourpreset-'.$presetno.' .right {';
                echo 'width: '.$sectionpreset->framedsectionborderwidth.'px;';
                echo '}';

                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main.colourpreset-'.$presetno.' .content {';
                echo 'margin: 0 '.$sectionpreset->framedsectionborderwidth.'px;';
                echo '}';

                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main.colourpreset-'.$presetno.' .header,'.
                     'body:not(.editing) .course-content ul.ned-framedsections .section.main.colourpreset-'.$presetno.' .footer,'.
                     'body:not(.editing) .course-content ul.ned-framedsections .section.main.colourpreset-'.$presetno.
                      ' .header .nedshfcolumnswithoutcontent {';
                echo 'min-height: '.$sectionpreset->framedsectionborderwidth.'px;';
                echo '}';
            }

            echo '/* ]]> */';
            echo '</style>';
        }
    } else {
        $formatcolourpreset = $courseformat->get_setting('colourpreset');
        if (!empty($formatcolourpreset)) { // 0 is 'Format / Theme default'.
            if ($preset = $DB->get_record('format_ned_colour', array('id' => $formatcolourpreset))) {
                echo '<style type="text/css" media="screen">';
                echo '/* <![CDATA[ */';

                if ($weareediting) {
                    echo 'ul.ned-framedsections .section.main .header,';
                    echo 'ul.ned-framedsections .section.main .footer {';
                    echo 'background-color: #'.$preset->framedsectionbgcolour.';';
                    echo '}';

                    echo 'ul.ned-framedsections .section.main .content {';
                    echo 'border-left-color: #'.$preset->framedsectionbgcolour.';';
                    echo 'border-right-color: #'.$preset->framedsectionbgcolour.';';
                    echo '}';
                } else {
                    echo 'ul.ned-framedsections .section.main {';
                    echo 'background-color: #'.$preset->framedsectionbgcolour.';';
                    echo '}';
                }

                echo '.ned-framedsections .section .header .sectionname,';
                echo '.ned-framedsections .section .header .sectionname a,';
                echo '.ned-framedsections .section .header .sectionname a:hover,';
                echo '.ned-framedsections .section .header .summary {';
                echo 'color: #'.$preset->framedsectionheadertxtcolour.';';
                echo '}';

                echo 'body:not(.editing) .course-content ul.ned.ned-framedsections li.section .left, ';
                echo 'body:not(.editing) .course-content ul.ned.ned-framedsections li.section .right {';
                echo 'width: '.$preset->framedsectionborderwidth.'px;';
                echo '}';
                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main .content {';
                echo 'margin: 0 '.$preset->framedsectionborderwidth.'px;';
                echo '}';
                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main .header, ';
                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main .footer, ';
                echo 'body:not(.editing) .course-content ul.ned-framedsections .section.main .header'.
                    ' .nedshfcolumnswithoutcontent {';
                echo 'min-height: '.$preset->framedsectionborderwidth.'px;';
                echo '}';

                echo '/* ]]> */';
                echo '</style>';
            } /* else Should not happen as when presets are deleted then courses are updated, but in a
                 multi-user environment then could happen if deleted at the same time as page load. */
        }
    }
}

$course = $courseformat->get_course();

if (($marker >= 0) && has_capability('moodle/course:setcurrentsection', $context) && confirm_sesskey()) {
    $course->marker = $marker;
    course_set_marker($course->id, $marker);
}

// Make sure section 0 is created.
course_create_sections_if_missing($course, 0);

$renderer = $PAGE->get_renderer('format_ned');
$renderer->set_courseformat($courseformat, (!empty($displaysection)));

if (!empty($displaysection)) {
    $renderer->print_single_section_page($course, null, null, null, null, $displaysection);
} else {
    $renderer->print_multiple_section_page($course, null, null, null, null);
}

// Include course format js module.
$PAGE->requires->js('/course/format/ned/format.js');
