<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * NED Filter
 *
 * @package    filter
 * @subpackage NED
 * @copyright  2017 Michael Gardener mgardener@cissq.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/filter/ned/lib.php');

class filter_ned extends moodle_text_filter {
    public static $filtercontext;

    public function filter($text, array $options = array()) {

        \filter_ned::$filtercontext = $this->context;
        \filter_ned\shortcode::add('sub', 'filter_ned_sub');
        \filter_ned\shortcode::add('ned-course-users', 'filter_ned_course_users');
        \filter_ned\shortcode::add('ned-course-users-teachers', 'filter_ned_course_users_teachers');
        \filter_ned\shortcode::add('ned-course-users-student', 'filter_ned_course_users_student');
        \filter_ned\shortcode::add('ned-course-home', 'filter_ned_course_home');
        \filter_ned\shortcode::add('ned-grades', 'filter_ned_grades');
        \filter_ned\shortcode::add('ned-progress-report', 'filter_ned_progress_report');
        \filter_ned\shortcode::add('ned-clink1', 'filter_ned_clink1');
        \filter_ned\shortcode::add('ned-clink2', 'filter_ned_clink2');
        \filter_ned\shortcode::add('ned-clink3', 'filter_ned_clink3');

        return \filter_ned\shortcode::parse($text);
    }
}