define(['jquery', 'core/url'], function ($, Url) {
    const CMID = '.gradeform.mform input[name="id"]';
    const GRADINGINSTANCEID = '.gradeform.mform input[name="gradinginstanceid"]';
    const ROOT = '#gradingform_kica_export';
    const EXPORT_BUTTON = '[data-action="export"]';
    const INPUT_EXPORT = '[name="export"]';
    const INPUT_ALLATTEMPTS = '[name="includeallattampts"]';
    const INPUT_CRITERIATEXT = '[name="includecriteriateext"]';
    const INPUT_INACTIVESTUDENTS = '[name="includeinactivestudents"]';
    const INPUT_UNGRADEDSTUDENTS = '[name="includeungradedstudents"]';

    /**
     * Listen to, and handle events for the kica rubric.
     * @param {string} href
     */
    function openUrl(href) {
        Object.assign(document.createElement('a'), {
            target: '_blank',
            rel: 'noopener noreferrer',
            href: href,
        }).click();
    }

    /**
     * Listen to, and handle events for the kica rubric.
     */
    function registerEventListeners() {
        $(ROOT + ' ' + EXPORT_BUTTON).on("click", function() {
            let cmid = $(CMID).val();
            let gradinginstanceid = $(GRADINGINSTANCEID).val();
            let exporttype = $(INPUT_EXPORT).val();
            let includeallattampts = $(INPUT_ALLATTEMPTS).prop("checked");
            let includecriteriateext = $(INPUT_CRITERIATEXT).prop("checked");
            let includeinactivestudents = $(INPUT_INACTIVESTUDENTS).prop("checked");
            let includeungradedstudents = $(INPUT_UNGRADEDSTUDENTS).prop("checked");
            let params = {
                'cmid': cmid,
                'exporttype': exporttype,
                'includeallattampts': includeallattampts,
                'includecriteriateext': includecriteriateext,
                'includeinactivestudents': includeinactivestudents,
                'includeungradedstudents': includeungradedstudents,
                'gradinginstanceid': gradinginstanceid,
            };
            let href = Url.relativeUrl('/grade/grading/form/kica/export.php', params, true);
            if (exporttype != '') {
                openUrl(href);
            }
        });
    }

    return {
        init: function() {
            registerEventListeners();
        }
    };
});
