<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Support for restore API
 *
 * @package    gradingform_kica
 * @copyright  2011 David Mudrak <david@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Restores the kica specific data from grading.xml file
 *
 * @package    gradingform_kica
 * @copyright  2011 David Mudrak <david@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class restore_gradingform_kica_plugin extends restore_gradingform_plugin {

    /**
     * Declares the kica XML paths attached to the form definition element
     *
     * @return array of {@link restore_path_element}
     */
    protected function define_definition_plugin_structure() {

        $paths = array();

        $paths[] = new restore_path_element('gradingform_kica_criterion',
            $this->get_pathfor('/kicacriteria/kicacriterion'));

        $paths[] = new restore_path_element('gradingform_kica_level',
            $this->get_pathfor('/kicacriteria/kicacriterion/kicalevels/kicalevel'));

        return $paths;
    }

    /**
     * Declares the kica XML paths attached to the form instance element
     *
     * @return array of {@link restore_path_element}
     */
    protected function define_instance_plugin_structure() {

        $paths = array();

        $paths[] = new restore_path_element('gradinform_kica_filling',
            $this->get_pathfor('/kicafillings/kicafilling'));

        return $paths;
    }

    /**
     * Processes criterion element data
     *
     * Sets the mapping 'gradingform_kica_criterion' to be used later by
     * {@link self::process_gradinform_kica_filling()}
     *
     * @param stdClass|array $data
     */
    public function process_gradingform_kica_criterion($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        $data->definitionid = $this->get_new_parentid('grading_definition');

        $newid = $DB->insert_record('gradingform_kica_criteria', $data);
        $this->set_mapping('gradingform_kica_criterion', $oldid, $newid);
    }

    /**
     * Processes level element data
     *
     * Sets the mapping 'gradingform_kica_level' to be used later by
     * {@link self::process_gradinform_kica_filling()}
     *
     * @param stdClass|array $data
     */
    public function process_gradingform_kica_level($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        $data->criterionid = $this->get_new_parentid('gradingform_kica_criterion');

        $newid = $DB->insert_record('gradingform_kica_levels', $data);
        $this->set_mapping('gradingform_kica_level', $oldid, $newid);
    }

    /**
     * Processes filling element data
     *
     * @param stdClass|array $data
     */
    public function process_gradinform_kica_filling($data) {
        global $DB;

        $data = (object)$data;
        $data->instanceid = $this->get_new_parentid('grading_instance');
        $data->criterionid = $this->get_mappingid('gradingform_kica_criterion', $data->criterionid);
        $data->levelid = $this->get_mappingid('gradingform_kica_level', $data->levelid);

        if (!empty($data->criterionid)) {
            $DB->insert_record('gradingform_kica_fillings', $data);
        }
    }
}