M.gradingform_kica = {};

/**
 * This function is called for each rubric on page.
 */
M.gradingform_kica.init = function(Y, options) {
    //Y.on('click', M.gradingform_kica.levelclick, '#rubric-'+options.name+' .level', null, Y, options.name);
    // Capture also space and enter keypress.
    //Y.on('key', M.gradingform_kica.levelclick, '#rubric-' + options.name + ' .level', 'space', Y, options.name);
    //Y.on('key', M.gradingform_kica.levelclick, '#rubric-' + options.name + ' .level', 'enter', Y, options.name);

    Y.on('blur', function(e) {
        var grade = e.target;
        var mingrade, maxgrade;
        var levelthreshold = options.levelthreshold;
        var level, criteriel;
        var currentgrade = grade.get('value');
        criteriel = grade.get('parentNode').get('parentNode');

        mingrade = 0;
        maxgrade = criteriel.getData('max');
        currentgrade = parseFloat(currentgrade);
        level = M.gradingform_kica.findlevel(maxgrade ? (currentgrade/maxgrade * 100) : 0, levelthreshold);

        criteriel.all('.level').removeClass('checked');
        criteriel.all('.level').setAttribute('aria-checked', 'false');
        criteriel.all('.level input[type=radio]').set('checked', false);

        criteriel.one('td[data-level="' + level + '"]').addClass('checked');
        criteriel.one('td[data-level="' + level + '"]').setAttribute('aria-checked', 'true');
        criteriel.one('td[data-level="' + level + '"] input[type=radio]').set('checked', true);

        if (isNaN(currentgrade) || currentgrade === null) {
            grade.set('value', '');
            grade.setStyle('background', '#ffcdd2');
        } else if (currentgrade > maxgrade) {
            grade.setStyle('background', '#ffcdd2');
            grade.set('value', '');
        } else if (currentgrade < mingrade) {
            grade.setStyle('background', '#ffcdd2');
            grade.set('value', '');
        } else {
            grade.setStyle('background', '');
        }

    }, '.level-grade');

    Y.all('#rubric-'+options.name+' .radio').setStyle('display', 'none')
    Y.all('#rubric-'+options.name+' .level').each(function (node) {
      if (node.one('input[type=radio]').get('checked')) {
        node.addClass('checked');
      }
    });
};

M.gradingform_kica.levelclick = function(e, Y, name) {
    var el = e.target
    while (el && !el.hasClass('level')) el = el.get('parentNode')
    if (!el) return
    e.preventDefault();
    el.siblings().removeClass('checked');

    // Set aria-checked attribute for siblings to false.
    el.siblings().setAttribute('aria-checked', 'false');
    chb = el.one('input[type=radio]');

    var mingrade = chb.getAttribute('data-min');
    var maxgrade = chb.getAttribute('data-max');

    var elementname = chb.get('name');
    elementname = elementname.replace('[levelid]', '[grade]');
    var grade = Y.one('input[name="' + elementname + '"]');

    var currentgrade = grade.get('value');

    mingrade = parseFloat(mingrade);
    maxgrade = parseFloat(maxgrade);
    currentgrade = parseFloat(currentgrade);

    if (isNaN(currentgrade) || currentgrade === null) {
        grade.set('value', '');
        grade.setStyle('background', '#ffcdd2');
    } else if (currentgrade > maxgrade) {
        grade.setStyle('background', '#ffcdd2');
        grade.set('value', '');
    } else if (currentgrade < mingrade) {
        grade.setStyle('background', '#ffcdd2');
        grade.set('value', '');
    } else {
        grade.setStyle('background', '');
    }

    if (!chb.get('checked')) {
        chb.set('checked', true)
        el.addClass('checked')
        // Set aria-checked attribute to true if checked.
        el.setAttribute('aria-checked', 'true');
    } else {
        el.removeClass('checked');
        // Set aria-checked attribute to false if unchecked.
        el.setAttribute('aria-checked', 'false');
        el.get('parentNode').all('input[type=radio]').set('checked', false)
    }
}

M.gradingform_kica.findlevel = function (grade, threshold) {
    var level = 0;
    for (var i in threshold) {
        if (grade >= threshold[i].threshold) {
            return threshold[i].level;
        }
    }
    return level;
}

