/**
 * Show grade category info modal instead of doing it on a separate page.
 *
 * @module     radix_assignment/category_summary
 * @class      category_summary
 * @package    radix_assignment
 * @copyright  2019 Mustafa Bahcaci <mbahcaci@charterresources.us>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'core/modal_factory', 'core/modal_events', 'core/str', 'core/notification', 'core/ajax', 'core/url'],
    function($, ModalFactory, ModalEvents, Str, Notification, Ajax, Url) {

        return {
            /**
             * Global init function for this module.
             *
             * @method init
             */
            init: function() {
                $('#checkgrades').click(function(e) {
                    $('[name=myform]').find('input:checkbox').prop('checked', true);
                    e.preventDefault();
                });
                $('#uncheckgrades').click(function(e) {
                    $('[name=myform]').find('input:checkbox').prop('checked', false);
                    e.preventDefault();
                });

                var trigger = $('[data-action=createconfirmmodal]');
                var form = $('#zero-grades-form');

                trigger.click(function(e) {
                    e.preventDefault();

                    var stringkeys = [
                        {key: 'confirm'},
                        {key: 'confirmgivezero', component: 'local_kica'},
                        {key: 'yes'},
                    ];

                    Str.get_strings(stringkeys).then(function(langStrings) {
                        var title = langStrings[0];
                        var confirmMessage = langStrings[1];
                        var buttonText = langStrings[2];
                        return ModalFactory.create({
                            title: title,
                            body: confirmMessage,
                            type: ModalFactory.types.SAVE_CANCEL
                        }).then(function(modal) {
                            modal.setSaveButtonText(buttonText);

                            // Handle save event.
                            modal.getRoot().on(ModalEvents.save, function() {
                                form.submit();
                            });

                            // Handle hidden event.
                            modal.getRoot().on(ModalEvents.hidden, function() {
                                // Destroy when hidden.
                                modal.destroy();
                            });

                            return modal;
                        });
                    }).done(function(modal) {
                        modal.show();

                    }).fail(Notification.exception);
                });










                $.when(
                    Str.get_strings([
                        {key: 'confirm'},
                        {key: 'confirmgivezero', component: 'local_kica'},
                        {key: 'yes'},
                    ]),
                    ModalFactory.create({
                        type: ModalFactory.types.SAVE_CANCEL,
                        title: '',
                        body: ''
                    })
                )
                .then(function(strings, modal) {
                    modal.setTitle(strings[0]);
                    modal.setSaveButtonText(strings[2]);
                    trigger.click(function() {
                        modal.getRoot().on(ModalEvents.hidden, function() {
                            modal.setBody(strings[1]);
                        });
                        modal.show();
                        modal.setBody(strings[1]);
                    });
                }).fail(Notification.exception);
            }
        };
    });
