<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines restore_local_kica class.
 *
 * @package     local_kica
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Restore plugin class.
 *
 * @package    local_kica
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class restore_local_kica_plugin extends restore_format_plugin {
    /**
     * Returns the paths to be handled by the plugin at course level.
     */
    protected function define_course_plugin_structure() {
        $paths = array();

        $elepath = $this->get_pathfor('/');
        $paths[] = new restore_path_element('localkica', $elepath.'/localkica');
        $paths[] = new restore_path_element('localkicaitem', $elepath.'/localkicaitems/localkicaitem');
        $paths[] = new restore_path_element('localkicagrade', $elepath.'/localkicaitems/localkicaitem/localkicagrades/localkicagrade');

        return $paths;
    }

    /**
     * Process local_kica table.
     * @param stdClass $data
     */
    public function process_localkica($data) {
        global $DB;

        $data = (object) $data;
        $data->courseid = $this->task->get_courseid();

        $DB->insert_record('local_kica', $data);
    }

    /**
     * Process local_kica_grade_items table.
     * @param stdClass $data
     */
    public function process_localkicaitem($data) {
        global $DB;
        $data = (object) $data;
        $oldid = $data->id;
        $data->courseid = $this->task->get_courseid();
        $newitemid =  $DB->insert_record('local_kica_grade_items', $data);
        $this->set_mapping('localkicaitem', $oldid, $newitemid, true);
    }
    /**
     * Process local_kica_grade_grades table.
     * @param stdClass $data
     */
    public function process_localkicagrade($data) {
        global $DB;

        $data = (object) $data;

        $data->courseid = $this->task->get_courseid();
        if ($data->userid = $this->get_mappingid('user', $data->userid)) {
            $data->itemid = $this->get_mappingid('localkicaitem', $data->itemid);
            $DB->insert_record('local_kica_grade_grades', $data);
        }
    }

    /**
     * We call the after restore_course to update the grade itemid ids we didn't know when creating.
     */
    protected function after_restore_course() {
        global $DB;
        // Fix local_kica_grade_items records.
        $rcm = $DB->get_recordset('local_kica_grade_items', array('courseid' => $this->task->get_courseid()));
        foreach ($rcm as $rc) {
            $rc->itemid = $this->get_mappingid('grade_item', $rc->itemid);
            $DB->update_record('local_kica_grade_items', $rc);
        }
        $rcm->close();

        // Delete corrupted items.
        $rcm = $DB->get_recordset_select('local_kica_grade_items', 'itemid = 0 AND courseid = ?', array($this->task->get_courseid()));
        foreach ($rcm as $rc) {
            $DB->delete_records('local_kica_grade_grades', ['itemid' => $rc->id]);
            $DB->delete_records('local_kica_grade_items', ['id' => $rc->id]);
        }
        $rcm->close();

        // Fix area ids
        $rcm = $DB->get_recordset_select('local_kica_grade_items', 'areaid > 0 AND courseid = ?', array($this->task->get_courseid()));
        foreach ($rcm as $rc) {
            $item = $DB->get_record('grade_items', array('id' => $rc->itemid));

            if (!$item || $item->itemtype != 'mod') {
                continue;
            }

            if (!$cm = get_coursemodule_from_instance($item->itemmodule, $item->iteminstance, $item->courseid)) {
                continue;
            }

            $sql = "SELECT ga.* 
                      FROM {context} ctx
                      JOIN {grading_areas} ga
                        ON ctx.id = ga.contextid
                     WHERE ctx.contextlevel = ? 
                       AND ctx.instanceid = ?";

            if ($area = $DB->get_record_sql($sql, array(CONTEXT_MODULE, $cm->id))) {
                $rc->areaid = $area->id;
                $DB->update_record('local_kica_grade_items', $rc);
            }
        }
        $rcm->close();
    }
}
