<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Assign role to cohort form.
 *
 * @package    tool_cohortroles
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kica\form;

defined('MOODLE_INTERNAL') || die();

use local_kica\shared_lib as NED;

NED::require_lib('/formslib.php');
NED::require_lib('/gradelib.php');

/**
 * KICA course setting form.
 *
 * @package    local_kica
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class kicaactivities_add extends \moodleform {

    /**
     * Form definition
     */
    public function definition() {
        $mform = $this->_form;
        $customdate = $this->_customdata;
        $courseid = $customdate['courseid'] ?? 0;
        if (!$courseid){
            return;
        }

        $mform->addElement('header', '', $customdate['kicagroupheader'], '');

        $activities = NED::get_important_activities($courseid);
        NED::ki_get_all_by_course($courseid, null, null, true);
        foreach ($activities as $mod){
            if (!NED::get_grade_item_by_cm_course($mod, $courseid)){
                continue;
            }

            if (NED::ki_get_by_cm($mod, true)){
                continue;
            }

            $mform->addElement('advcheckbox', 'activity' . $mod->id, '',  NED::q_cm_name($mod), ['group' => $mod->section], [0, $mod->id]);
        }

        $mform->addElement('hidden', 'courseid');
        $mform->setType('courseid', PARAM_INT);
        $mform->addElement('hidden', 'kicagroup');
        $mform->setType('kicagroup', PARAM_INT);

        $this->add_action_buttons(true, NED::str('submit'));
    }

    /**
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files) {
        $errors = array();
        return $errors;
    }

}
