<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kica
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\output\menu_bar as KMB;
use local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/local/kica/lib.php');
require_once($CFG->dirroot.'/local/kica/classes/helper.php');

$mode = optional_param(kica\P_MODE, kica\MODE_VIEW, PARAM_RAW);
if ($mode != kica\MODE_EDIT){
    $mode = kica\MODE_VIEW;
}

$KMB = new KMB(KMB::PAGE_KICA, [kica\P_MODE => $mode], null, true);
$courseid = $KMB->courseid;
$userid = $KMB->userid;
$user = $KMB->user;
$coursecontext = $KMB->context;

if (!local_kica\helper::iskicaready($courseid)) {
    redirect($KMB->get_url(KMB::PAGE_KICA_ACTIVITIES));
}

// Security.
$caneditgrade = has_capability('moodle/grade:edit', $coursecontext);
$isgrader = $caneditgrade && $KMB->isteacher;
// Does not allow edit mode.
if (!$caneditgrade) {
    $mode = kica\MODE_VIEW;
}

$gradeview = '';
if ($isgrader){
    $gradeview = kica\VIEW_GRADER;
} elseif ($KMB->isteacher) { // teacher, but not grader
    $gradeview = kica\VIEW_READONLY;
} elseif (has_capability('gradereport/user:view', $coursecontext)){
    $gradeview = kica\VIEW_USER;
    $userid = $USER->id;
    $user = $USER;
} else {
    NED::print_module_error('nopermissiontoviewgrades', 'error',  $KMB->get_url(null, [KMB::PAR_COURSE => $KMB->courseid]));
}

if ($gradeview != kica\VIEW_GRADER){
    // Does not allow edit mode.
    $mode = kica\MODE_VIEW;
}

$thispageurl = $KMB->get_url();
if ($gradeview == kica\VIEW_USER){
    $PAGE->set_pagelayout('course');
}

NED::js_call_amd('grade');
$KMB->set_page_params();

/** @var local_kica\output\renderer $renderer */
$renderer = NED::get_renderer();
$students = $KMB->students;

$user_output = '';
if ($userid){
    $user_output = $renderer->print_grade_user($courseid, $user, $thispageurl, $gradeview, $mode, true);
} elseif ($KMB->groupid >= 0 && !empty($students)) {
    $user_output = $renderer->print_users_grades($courseid, $students, true);
} else {
    $user_output = NED::notification('nostudents', NED::NOTIFY_WARNING);
}

echo $OUTPUT->header();

if ($gradeview != kica\VIEW_USER){
    $KMB->render();
}

$o = $KMB->render_kica_selector_menu(true);
if ($isgrader) {
    $o .= $KMB->print_grading_errors(true);
}
$o .= $user_output;

echo NED::div($o, 'kica-main');
echo $OUTPUT->footer();
