<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * local_kica.
 *
 * @package     local_kica
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
use \local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

$courseid = required_param('courseid', PARAM_INT);
$kicagroup = required_param('kicagroup', PARAM_INT);

$course = get_course($courseid);
require_login($course);

$course = course_get_format($course)->get_course();
$coursecontext = NED::ctx($course->id);

// Security.
require_capability('moodle/grade:viewall', $coursecontext);
require_capability('moodle/grade:edit', $coursecontext);
NED::require_capability('manage', $coursecontext);

$kicagroups = NED::get_kica_groups($courseid);
if (!isset($kicagroups[$kicagroup])){
    NED::print_error('kicagroup');
}

// Page boilerplate stuff.
$thispageurl = NED::url('~/kicaactivities_add.php', ['courseid' => $courseid]);
$redirecturl = NED::url('~/kicaactivities.php', ['courseid' => $courseid]);

$PAGE->set_context($coursecontext);
$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('admin');
NED::js_call_amd('/kicaactivities_add');

$title = NED::str('kicagradebooksetup');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->navbar->add($title);

$kica_group_title = NED::str('groupheader'.$kicagroup, $kicagroups[$kicagroup]);
$mform = new local_kica\form\kicaactivities_add(null, ['courseid' => $course->id, 'kicagroupheader' => $kica_group_title]);

if ($mform->is_cancelled()) {
    redirect($redirecturl);
} else if ($fromform = $mform->get_data()) {
    $cmids = local_kica\helper::get_activity_cmids_from_form($fromform);
    foreach ($cmids as $cmid) {
        $gradeitem = NED::ki_get_by_cm($cmid);
        if (empty($gradeitem)){
            continue;
        }

        $gradeitem->kicagroup = $fromform->kicagroup;
        if ($gradeitem->id) {
            $gradeitem->update();
        } else {
            $gradeitem->insert();
        }
    }
    redirect($redirecturl);
    exit;
}

echo $OUTPUT->header();
echo $OUTPUT->heading(NED::str('kicaactivities'));

$toform = new stdClass();
$toform->courseid = $courseid;
$toform->kicagroup = $kicagroup;
$mform->set_data($toform);
$mform->display();

echo $OUTPUT->footer();