<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * local_kica.
 *
 * @package     local_kica
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use \local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

$id = required_param('id', PARAM_INT);
$courseid = required_param('courseid', PARAM_INT);
$process = optional_param('process', 0, PARAM_INT);

$course = get_course($courseid);
$coursecontext = NED::ctx($courseid);
require_login($course);

// Security.
require_capability('moodle/grade:viewall', $coursecontext);
require_capability('moodle/grade:edit', $coursecontext);
NED::require_capability('manage', $coursecontext);

// Page boilerplate stuff.
$thispageurl = NED::url('~/kicaactivities_delete.php', ['id' => $id,'courseid' => $courseid]);
$redirecturl = NED::url('~/kicaactivities.php', ['courseid' => $courseid]);

$PAGE->set_context($coursecontext);
$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('admin');

$title = get_string('kicagradebooksetup', 'local_kica');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->navbar->add($title);

$kicaitem = local_kica\kica_item::get_by_id($id);
if (!empty($kicaitem->id) && $process) {
    $kicaitem->delete();
    redirect($redirecturl);
    die;
}

echo $OUTPUT->header();
if (!empty($kicaitem->id)){
    echo NED::tag('h1', $title, 'local-kica-title');
    $processurl = clone $thispageurl;
    $processurl->param('process', 1);
    echo $OUTPUT->confirm(
        get_string('deletecheck', 'moodle', $kicaitem->itemname),
        $processurl,
        $redirecturl
    );
} else {
    echo NED::tag('h1', NED::str('error_nokicaitem'), 'local-kica-title error');
}
echo $OUTPUT->footer();
