<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * local_kica.
 *
 * @package     local_kica
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use \local_kica as kica;
use \local_kica\output\menu_bar as KMB;
use \local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

$id = required_param('id', PARAM_INT);
$courseid = required_param(KMB::PAR_COURSE, PARAM_INT);

$course = get_course($courseid);
require_login($course);
$coursecontext = NED::ctx($courseid);

// Security.
NED::require_capability('manage', $coursecontext);

// Page boilerplate stuff.
$thispageurl = NED::url('~/kicaactivities_edit.php', ['id' => $id, KMB::PAR_COURSE => $courseid]);
$redirecturl = NED::url('~/kicaactivities.php', [KMB::PAR_COURSE => $courseid]);
$PAGE->set_context($coursecontext);
$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('admin');

$title = NED::str('kicagradebooksetup');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->navbar->add($title);

$toform = NED::ki_get_by_id_existing($id);
if ($toform->areaid) {
    $area = NED::get_grading_area($toform->areaid);
} else {
    $area = null;
}

$gradeitem = NED::get_grade_item_by_id_or_params($toform->itemid);
$mform = new local_kica\form\kicaactivities_edit(null, ['gradeitem' => $gradeitem, 'area' => $area, KMB::PAR_COURSE => $courseid]);

if ($mform->is_cancelled()) {
    redirect($redirecturl);
} elseif ($fromform = $mform->get_data()) {
    $kicagradeitem = NED::ki_get_by_id($fromform->id);
    if (!$kicagradeitem){
        NED::redirect($redirecturl, NED::str('error_nokicaitem'), null, NED::NOTIFY_ERROR);
    }

    $upd = false;
    if (!empty($fromform->kicagroup)) {
        $kicagradeitem->kicagroup = $fromform->kicagroup;
        $upd = true;
    }

    if (is_null($area)) {
        foreach (NED::KICA_KEYS as $k_key){
            if (isset($fromform->$k_key)){
                $kicagradeitem->$k_key = $fromform->$k_key;
                $upd = true;
            }
        }
    }

    if ($upd){
        $kicagradeitem->update();
    }

    if (!is_null($area)){
        redirect($redirecturl);
        exit;
    }

    $flag = $kicagradeitem->get_flag();
    if ($flag && $kicagradeitem->activity_has_grade()){
        redirect(KMB::get_page_moodle_url(KMB::PAGE_KICA_GRADE_ACTIVITY,
            [KMB::PAR_COURSE => $courseid, kica\P_ITEM => $kicagradeitem->id, kica\P_MODE => kica\MODE_EDIT, kica\P_FILTER => 'flag']));
    }
    redirect($redirecturl);
    exit;
}

echo $OUTPUT->header();
echo $OUTPUT->heading(NED::str('kicaactivities'));
if (!$id) {
    $toform = new stdClass();
    $toform->courseid = $course->id;
}
$mform->set_data($toform);
$mform->display();
echo $OUTPUT->footer();