<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     local_kica
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'KICA Gradebook';
$string['kica:manage'] = 'KICA Gradebook manage';
$string['kica:viewgradedisparity'] = 'View grade disparity';
$string['kicagradebooksetup'] = 'KICA Gradebook Setup';
$string['enablekicainthiscourse'] = 'Enable KICA in this course';
$string['kicaweightincourse'] = 'Weight of all KICA activities in course total';
$string['nameofseventypercent'] = 'Name of 70% group';
$string['nameofthirtypercent'] = 'Name of 30% group';
$string['nameoftwentypercent'] = 'Name of 20% group';
$string['nameoftenpercent'] = 'Name of 10% group';
$string['groupheader70'] = '{$a} (70%)';
$string['groupheader30'] = '{$a} (30%)';
$string['groupheader20'] = '{$a} (20%)';
$string['groupheader10'] = '{$a} (10%)';
$string['kicadistribution'] = 'KICA distribution';
$string['knowledge'] = 'Knowledge';
$string['inquiry'] = 'Inquiry';
$string['communication'] = 'Communication';
$string['application'] = 'Application';
$string['finalgrade'] = 'Grade';
$string['shortknowledge'] = 'K';
$string['shortinquiry'] = 'I';
$string['shortcommunication'] = 'C';
$string['shortapplication'] = 'A';
$string['coursework'] = 'Course Work';
$string['finalexam'] = 'Final Exam';
$string['finalproject'] = 'Final Project';
$string['gradedactivitieswithkica'] = 'Graded activities with KICA';
$string['gradedactivitieswithoutkica'] = 'Graded activities without KICA';
$string['select'] = 'Select';
$string['kicadistributionless'] = 'Total KICA distribution cannot be less than {$a}';
$string['kicadistributiongreater'] = 'Total KICA distribution cannot be greater than {$a}';
$string['kicacoursegradesettings'] = 'Manage settings';
$string['kicaactivities'] = 'Manage activities';
$string['nonkicaactivities'] = 'Non-KICA activities';
$string['itemname'] = 'Name';
$string['grademax'] = 'Grade';
$string['actions'] = 'Actions';
$string['submit'] = 'Submit';
$string['defaultsectionname'] = 'Section-{$a}';
$string['activity'] = 'Activity';
$string['activities'] = 'Activities';
$string['add'] = 'Add';
$string['kicagrade'] = 'Grade';
$string['kica_grade'] = 'KICA Grade';
$string['grade'] = 'Grade';
$string['edit'] = 'Edit';
$string['savechanges'] = 'Save changes';
$string['incompletekicactivitiesnotification'] = 'Error: Grade mismatch detected. The KICA Gradebook cannot be used until the
activities highlighted below are fixed.';
$string['errornonzero'] = 'It must be greater than zero';
$string['kicatotal'] = 'KICA Total';
$string['coursegrade'] = 'Course grade';
$string['gradecalculation'] = 'Grade Calculation';
$string['gradebookstudentview'] = 'Student View';
$string['gradebookactivityview'] = 'Activity View';
$string['allactivities'] = 'All activities';
$string['selectuser'] = 'Select user...';
$string['pullfromgradebook'] = 'Pull grades from Moodle gradebook';
$string['pullfromgradebook_help'] = 'KICA scores must add up to Moodle grade in each activity';
$string['errorsrequireattention'] = '{$a} errors require attention';
$string['activitiesrequiregrade'] = '{$a} Activities require KICA grades';
$string['graderangemismatch'] = 'Error: Max grade in KICA Gradebook does not match max grade in Moodle Gradebook';
$string['gradeawardedmismatch'] = 'Error: Grade awarded in KICA Gradebook does not match Moodle Gradebook';
$string['ungradedactivities'] = 'Ungraded activities';
$string['notifications'] = 'Notifications';
$string['nonotifications'] = 'There are no notifications';
$string['editkicagrades'] = 'Edit KICA Grades';
$string['cancel'] = 'Cancel';
$string['kicagroup'] = 'Percentage group';
$string['unlockdlgtitle'] = 'KICA ranges for this activity are locked';
$string['unlockdlgquestion'] = 'KICA scores have been awarded to some students. To Change the KICA ranges for this activity, you must also enter new KICA scores for these students.';
$string['unlockdlgyeslabel'] = 'Unlock and Continue';
$string['unlockdlgnolabel'] = 'Cancel';
$string['gradeflagged'] = 'Error: KICA ranges were changed after KICA scores were awarded to some students';
$string['rawgrade'] = 'KICA Grade';
$string['currentkicascore'] = 'Current KICA Score';
$string['currentcoursegrade'] = 'Current Course Grade';
$string['waitingforgradeallkicacat'] = 'Grade not available. Waiting for score in all four KICA categories';
$string['zerogradeerror'] = '{$a} student(s) have a zero grade in one or more activities in the Moodle Gradebook. These
grades currently don\'t exist in the KICA gradebook.';
$string['viewreport'] = 'View report';
$string['zerogrades'] = 'Zero grades';
$string['activityname'] = 'Activity name';
$string['studentname'] = 'Student name';
$string['importzerogrades'] = 'Import zero grades';
$string['confirmgivezero'] = 'Do you want to copy these zero grades into KICA Gradebook?';
$string['group'] = 'Group';
$string['dategraded'] = 'Date graded';
$string['showcalculationtitle'] = 'Show grade calculation';
$string['showmoodlegrades'] = 'Show moodle grades';
$string['moodlegradingpage'] = 'Moodle grading page';
$string['nedgradingpage'] = 'Ned grading page';
$string['viewactivity'] = 'View activity';
$string['activitysettings'] = 'Activity settings';
$string['showinactiveusers'] = 'Show inactive users';
$string['gradesplit'] = 'Grade split';
$string['kicacalculation'] = 'KICA Calculation';
$string['weighted'] = 'Weighted';
$string['natural'] = 'Natural';
$string['allgroups'] = 'All classes';
$string['allparticipants'] = 'All participants';
$string['student'] = 'Student';
$string['class'] = 'Class';
$string['completion'] = 'Completion';
$string['type'] = 'Type';
$string['graded'] = 'Graded';
$string['averagegrade'] = 'Average grade';
$string['totalaverage'] = 'Total average';
$string['kicarangeswerechanged'] = 'KICA ranges were changed after KICA scores were awarded to the following students. Click on the "Edit KICA Grades" button to resolve';
$string['excluded'] = 'Excluded activity';
$string['nostudents'] = 'There are no students to show';
$string['moodlegrader'] = 'Moodle Grader';
$string['markingmanager'] = 'Marking Manager';
$string['kicaquizgrader'] = 'KICA Quiz Grader';
$string['error_nokicaitem'] = 'Error: there is no such KICA item';
$string['assignmentsaverage'] = '{$a}% Assignments';
$string['testsaverage'] = '{$a}% Tests';
$string['pending'] = 'Pending';
$string['coursecompletedmsg'] = 'Congratulations. You have completed this course. No further submissions are allowed.';
$string['fixkicagrades'] = 'Fix KICA grades';
$string['recalculatekicascores'] = 'Recalculate KICA scores';
$string['recalculateconfirm'] = 'Are you sure you want to recalculate all KICA scores for the "{$a}" activity?';