<?php
/**
 * Plugins overview
 *
 * @package     local_ned_controller
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kica;
use local_kica\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

const P_MODE = 'mode';
const P_FILTER = 'filter';
const P_ITEM = 'itemid';

const VIEW_GRADER = 0;      // it's for teacher, which can grade
const VIEW_READONLY = 1;    // it's for teacher, which can't grade
const VIEW_USER = 2;        // it's for student, he can see only himself

const MODE_VIEW = 0;
const MODE_EDIT = 1;

/**
 * @param \html_table_row   $row
 * @param string            $type
 * @param \cm_info|object   $cm
 * @param int|string        $userid
 */
function add_row_action_menu(&$row, $type, $cm, $userid){
    $add2menu = [];

    switch ($type){
        default:
            debugging("There are no such type \"$type\" for the add_row_action_menu", DEBUG_DEVELOPER);
            return;
        case 'activity':
        case 'student':
            if ($cm->modname == 'quiz' && method_exists('\local_kicaquizgrading\helper', 'get_kica_grader_link_from_cm')) {
                if ($kicaquickgraderurl = \local_kicaquizgrading\helper::get_kica_grader_link_from_cm($cm, $userid)) {
                    $add2menu[] = [$kicaquickgraderurl, [], 'kicaquizgrader', 'fa-table'];
                }
            }
            break;
    }

    $menu = NED::get_activity_menu($cm, $userid, $add2menu, $type == 'student');
    $row->cells[count($row->cells)-1]->text .= $menu;
}
