<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kica
 * @category    Zero Grades
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\shared_lib as NED;
use local_kica\output\menu_bar as KMB;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

// Security.
$KMB = KMB::get_menu_bar(KMB::PAGE_KICA_ZEROGRADES);
$KMB->show_error_for_not_teacher(['moodle/grade:edit']);
$course = $KMB->course;
$courseid = $KMB->courseid;

if (!kica\helper::iskicaready($courseid)) {
    redirect($KMB->get_url(KMB::PAGE_KICA_ACTIVITIES));
}

if (($formdata = data_submitted()) && confirm_sesskey()) {
    foreach ($formdata as $k => $v) {
        if (strpos($k, 'zerograde_') === 0) {
            $arr = explode('_', $k);
            $gradeid = $arr['1'];
            $gradeitemid = $arr['2'];
            $userid = $arr['3'];
            $grade = ['knowledge' => 0, 'inquiry' => 0, 'communication' => 0, 'application' => 0];
            kica\helper::save_grade($gradeitemid, $userid, $grade);
        }
    }
    $returnurl = optional_param('returnurl', '', PARAM_LOCALURL);
    redirect(new moodle_url($returnurl));
    die;
}

$KMB->set_page_params(NED::str('zerogrades'));
NED::js_call_amd('zerogrades');
echo $OUTPUT->header();

$zerogrades = $KMB->get_zero_graded_users();

$table = NED::html_table('', null, ['',
    NED::str('activityname'),
    NED::str('studentname'),
    NED::str('group'),
    NED::str('dategraded'),
]);

foreach ($zerogrades as $zerograde) {
    $checkbox = NED::cell(
        html_writer::empty_tag(
            'input',
            array(
                'class' => 'usercheckbox',
                'name' => 'zerograde_' . $zerograde->id . '_' . $zerograde->kicaitemid . '_' . $zerograde->userid,
                'type' => 'checkbox'
            )
        )
    );
    $activitylink = NED::link(
        ['/grade/report/singleview/index.php', ['id' => $zerograde->courseid, 'item' => 'grade', 'group' => 0, 'itemid' => $zerograde->itemid]],
        $zerograde->itemname,
        ['target' => '_blank']);
    $row = [$checkbox, $activitylink, $zerograde->firstname .' '. $zerograde->lastname, $zerograde->groupname, userdate($zerograde->timemodified)];
    $table->data[] = $row;
}
$KMB->render();

// Form starts.
$formurl = $KMB->get_url();
echo html_writer::empty_tag('form',
    array(
        'name' => 'myform',
        'method' => 'post',
        'id' => 'zero-grades-form',
        'action' => $formurl->out(false)
    )
);
echo html_writer::empty_tag('input',
    array(
        'type' => 'hidden',
        'name' => 'sesskey',
        'value' => sesskey()
    )
);
echo html_writer::empty_tag('input',
    array(
        'type' => 'hidden',
        'name' => 'courseid',
        'value' => $course->id
    )
);
echo html_writer::empty_tag('input',
    array(
        'type' => 'hidden',
        'name' => 'returnurl',
        'value' => (new moodle_url('/local/kica/grade_activity.php', ['courseid' => $courseid]))->out_as_local_url()
    )
);
echo html_writer::start_tag('fieldset',
    array(
        'class' => 'invisiblefieldset',
        'style' => 'display: block;'
    )
);

echo NED::render_table($table);

echo html_writer::empty_tag('input', array('type' => 'hidden', 'sesskey' => sesskey()));
echo html_writer::empty_tag('input', array('type' => 'hidden', 'formaction' => ''));

echo html_writer::start_div('dispositionlistcontrols');
echo html_writer::link("#", get_string('selectall', 'quiz'), array('id' => 'checkgrades'));
echo ' | ';
echo html_writer::link("#", get_string('selectnone', 'quiz'), array('id' => 'uncheckgrades'));


echo html_writer::empty_tag('br');
echo html_writer::empty_tag('br');
echo html_writer::end_div();

echo html_writer::start_div('dispositionlistcontrols');

echo html_writer::empty_tag('input',
    array(
        'type' => 'button',
        'name' => 'bulkedit',
        'data-action' => 'createconfirmmodal',
        'value' => NED::str('importzerogrades')
    )
);

echo html_writer::end_div();
echo html_writer::end_tag('fieldset');
echo html_writer::end_tag('form');

echo $OUTPUT->footer();
