<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update KICA items
 *
 * @package    local_kicaquizgrading
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kicaquizgrading\task;

use local_kicaquizgrading\helper;

defined('MOODLE_INTERNAL') || die();

class update_kica_items extends \core\task\scheduled_task {

    public function get_name() {
        return get_string('updatekicaitems', 'local_kicaquizgrading');
    }

    public function execute() {
        global $CFG;
        if (!get_config('local_kicaquizgrading', 'enable')) {
            return false;
        }

        if (!class_exists('\local_kica\kica_item')) {
            return true;
        }

        $quizzes = helper::get_quizzes(0);

        foreach ($quizzes as $quiz) {
            helper::update_kica_item($quiz->id);
        }
    }
}