<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kicaquizgrading
 * @category    nstall
 * @copyright   2020 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

function xmldb_local_kicaquizgrading_install() {
    global $DB;

    $dbman = $DB->get_manager();

    // Define field knowledge to be added to question_attempt_steps.
    $table = new xmldb_table('question_attempt_steps');
    $field = new xmldb_field('knowledge', XMLDB_TYPE_NUMBER, '12, 7', null, null, null, null, 'fraction');

    // Conditionally launch add field knowledge.
    if (!$dbman->field_exists($table, $field)) {
        $dbman->add_field($table, $field);
    }

    // Define field inquiry to be added to question_attempt_steps.
    $table = new xmldb_table('question_attempt_steps');
    $field = new xmldb_field('inquiry', XMLDB_TYPE_NUMBER, '12, 7', null, null, null, null, 'knowledge');

    // Conditionally launch add field inquiry.
    if (!$dbman->field_exists($table, $field)) {
        $dbman->add_field($table, $field);
    }

    // Define field communication to be added to question_attempt_steps.
    $table = new xmldb_table('question_attempt_steps');
    $field = new xmldb_field('communication', XMLDB_TYPE_NUMBER, '12, 7', null, null, null, null, 'inquiry');

    // Conditionally launch add field communication.
    if (!$dbman->field_exists($table, $field)) {
        $dbman->add_field($table, $field);
    }

    // Define field application to be added to question_attempt_steps.
    $table = new xmldb_table('question_attempt_steps');
    $field = new xmldb_field('application', XMLDB_TYPE_NUMBER, '12, 7', null, null, null, null, 'communication');

    // Conditionally launch add field application.
    if (!$dbman->field_exists($table, $field)) {
        $dbman->add_field($table, $field);
    }

    return true;
}
