// noinspection JSUnusedLocalSymbols
define(['jquery', 'local_ned_controller/tablesorter'], function($, Tablesorter) {
    return {
        add_sort: function(selector, add_options={}) {
            if (Array.isArray(selector)){
                selector = selector.join(', ');
            }
            $(document).ready(function() {
                $(function() {
                    const def_options = {
                        headers: {},
                        cssAsc: 'sort-up',
                        cssDesc: 'sort-down',
                        cssNone: 'sort-none',
                        textAttribute: 'data-sort-value',
                        emptyTo: 'bottom',
                        sortReset: true,
                        sortStable: true,
                    };

                    let $datatables = $(selector);
                    let options = {
                        ...def_options,
                        ...(add_options || {})
                    }

                    $datatables.find('th:not([data-sorter])').attr('data-sorter', 'text');
                    $datatables.find('th:not(.sorter-false)').addClass('sorter-true');
                    $datatables.find('tr.nosort > td').attr('data-sort-value', '');
                    $datatables.tablesorter(options);
                });
            });
        },
    };
});
