define(['jquery'], function($) {
    let elems = [];
    let inited= false;
    return {
        add: function(selector) {
            if (Array.isArray(selector)){
                selector = selector.join(', ');
            }
            let $new_elems = $(selector);
            if (!$new_elems.length){
                return;
            }

            elems.push($new_elems.toArray());

            if (!inited){
                check_timer();
                inited = true;
            }
        },
    };

    function check_timer(){
        clearTimeout(check_timer.timerid);
        check_elems(elems)
        check_timer.timerid = setTimeout(check_timer, 1000);
    }

    function check_elems(_elems){
        _elems.forEach(function(elem){
            if (Array.isArray(elem)){
                check_elems(elem);
            }

            if (elem && !elem.parentElement) return;
            let $_elem = $(elem);

            let datetime = $_elem.data('datetime');
            if (datetime === undefined){
                return;
            }

            if (+datetime === 0){
                $_elem.text('∞');
                return;
            }
            let time_del = (datetime - Math.round(new Date().getTime()/1000));
            if (time_del < 0){
                elem.remove();
            } else {
                $_elem.text(time2str(time_del));
            }
        });


    }

    function time2str(time_del){
        let sign = '';
        if (time_del < 0){
            time_del = Math.abs(time_del);
            sign = '-';
        }
        let h = Math.floor(time_del/3600);
        time_del -= h*3600;
        let m = Math.floor(time_del/60);
        let s = time_del - m*60;
        let f = {'minimumIntegerDigits': 2};
        return sign + h.toLocaleString(0, f) + ':' + m.toLocaleString(0, f) + ':' + s.toLocaleString(0, f);
    }
});
