define(['jquery', 'core/modal_factory', 'core/templates', 'core/ajax', 'core/log'],
    function($, ModalFactory, Templates, Ajax, log) { return {
init: function(course_view = 0) {
    let T = this;
    $(document).ready(function(){
        let $table = $("table.nedtable");

        $table.delegate('.showdetails', 'click', function(){
            let $row = $(this).closest('.record');
            let title = $(this).text();
            if (!$row.length || !$row.data('id')){
                return false;
            }

            Ajax.call([{
                    methodname: 'local_ned_controller_ngc_info',
                    args: {ngc_info_params: {'id': $row.data('id'),'course_view': course_view}}
                }])[0]
                .done(function(response) {
                    ModalFactory.create({
                        type: ModalFactory.types.ALERT,
                        title: title,
                        body: response,
                    }).then(function(modal) {
                        modal.show();
                    }).fail(function(ex) {
                        T.error_debug('ModalFactory fail', ex);
                    });
                }).fail(function(ex) {
                    T.error_debug('Ajax fail', ex);
                });

            return false;
        });
    });
},
debug: function(txt){
    log.debug('[ned_grade_controller] ' + txt);
},
error_debug: function(txt, ex){
    let message = ex.message ? ex.message : ex.error;
    this.debug(`${txt}: \n${message}\n${ex.debuginfo}\n${ex.backtrace}`);
},
};});
