/**
 * AMD for ned_grade_controller_render page
 *
 * @module     local_ned_controller/ned_grade_controller_render
 * @package    local_ned_controller
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'core/str', 'core/notification'],
function($, Str, Notification) {
    let plugin = 'local_ned_controller';
    return {
        init: function() {
            let $table = $('table.nedtable');
            let $ngcr = $('.ned-grade-controller-render');

            let $ned_checkboxes = $table.find('tbody .record .ned_tags_checkbox');
            $table.delegate('thead .ned_tags_checkbox', 'change', function(e){
                $ned_checkboxes.prop('checked', e.target.checked);
            });

            $ngcr.delegate('.bulk-menu .ned-actionmenu .dropdown-menu a, .bulk-menu .ned-actionmenu ul.menu li a', 'click', function(e){
                e.preventDefault();
                let $elem = $(e.target);
                if (!$elem.has('.callform, .link')){
                    return;
                }

                let ngc_ids;
                if ($elem.closest('.bulk-menu').length){
                    ngc_ids = $ned_checkboxes.filter(':checked').map((i, el) => $(el).data('id')).get();
                    if (!ngc_ids.length){
                        str_alert('noselectedrecords');
                        return;
                    }
                } else {
                    ngc_ids = $elem.closest('tr.record').data('id');
                    if (!ngc_ids){
                        str_alert('unexpectederror');
                        return;
                    }
                    ngc_ids = [ngc_ids];
                }

                if ($elem.hasClass('link')){
                    let url = $elem.attr('href');
                    let pattern = encodeURI('{ids}');
                    if (url.includes(pattern)){
                        url = url.replace(pattern, ngc_ids.join(','));
                        document.location.replace(url);
                        return;
                    }
                }
            });
        }
    };

    function str_alert(key, pl=plugin, $a=null){
        $.when(Str.get_string(key, pl, $a)).done(function(localizedEditString) {
            alert(localizedEditString);
        });
    }
});
