/**
 * @package    local_ned_controller
 * @subpackage local_ned_controller/output/custom_ned_menu
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define(['jquery'], function ($) {
    const BLOCK_SEL = '.local_ned_controller-custom_ned_menu.block';
    const BLOCK_CONTENT_SEL = '#local_ned_controller-custom_ned_menu';
    const animClass = 'animation-processing';

    let _init = false;

    return {
        init: function () {
            if (_init) return;

            $(document).ready(function () {
                $(BLOCK_SEL+' '+BLOCK_CONTENT_SEL).delegate('.has-sub:not(.'+animClass+') > :not(ul) .holder-icon', 'click', function() {
                    let $li = $(this).closest('li');
                    $li.children('ul').slideToggle({
                        duration: 500,
                        easing: 'linear',
                        start: () => $li.addClass(animClass).toggleClass('active'),
                        always: () => $li.removeClass(animClass), // end
                    });
                });
            });

            _init = true;
        },
    };
});
