// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Local NED Controller.
 *
 * @package    local
 * @subpackage ned_controller
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'core/log', 'local_ned_controller/plotly'], function ($, log, Plotly) {
    let CheckSizeTimerID=0;
    let AllPlots = [];
    let resize = false;

    return {
        add: function(...list){
            call_Plotly(list);
        },
        add_list: function(list){
            call_Plotly(list);
        },
        add_json: function(json){
            call_Plotly($.parseJSON(json));
        },
        turn_resize_on: function(){
            resize = true;
            startTimer();
        },
    };

    function call_Plotly(list){
        let plots = [];
        // first check size and other options
        for(let i=0; i < list.length; i++){
            let [selector, data, layout, config] = list[i];
            let $elems = $(selector);
            $elems.each(function(){
                let elem = this;// $elem = $(this);
                if (!(layout.width || layout.height)){
                    if (config.square){
                        [layout.width, layout.height] = get_size(elem.clientWidth, elem.clientHeight, config);
                    } else {
                        layout.width = layout.width || elem.clientWidth;
                        layout.height = layout.height || elem.clientHeight;
                    }
                }
                plots.push([elem, data, layout, config]);
            });
        }
        // add plots
        for(let i=0; i < plots.length; i++){
            let [elem, data, layout, config] = plots[i];
            config.responsive = true;
            Plotly.newPlot(elem, data, layout, config);
            AllPlots.push([plots[i], elem.clientWidth,  elem.clientHeight]);
        }

        startTimer();
    }

    function startTimer(){
        if (!resize){
            return;
        }
        CheckSizeTimerID = setTimeout(CheckSize, 100);
    }

    function CheckSize(){
        clearTimeout(CheckSizeTimerID);

        let resize_plots = [];
        for(let i=0; i < AllPlots.length; i++){
            let [plot_data, width, height] = AllPlots[i];
            let elem = plot_data[0];
            if (elem.clientWidth !== width || elem.clientHeight !== height){
                let push = [plot_data, elem.clientWidth, elem.clientHeight];
                resize_plots.push(push);
                AllPlots[i] = push;
            }
        }

        for(let i=0; i < resize_plots.length; i++){
            let [plot_data, width, height] = resize_plots[i];
            let [elem, data, layout, config] = plot_data;
            if (config.square){
                [width, height] = get_size(width, height, config);
            }

            [layout.width, layout.height] = [width, height];
            Plotly.newPlot(elem, data, layout, config);
        }

        startTimer();
    }

    function get_size(width, height, config){
        let size=0, h=0, w=0;
        if (config['square']){
            if (width && height){
                if (config['get_min']){
                    size = Math.min(width, height);
                } else if(config['get_max']){
                    size = Math.max(width, height);
                } else if (config['get_height']){
                    size = height;
                } else if (config['get_width']){
                    size = width;
                } else {
                    size = width;
                }
            } else if (width || height){
                size = width || height;
            } else {
                if (config['get_height']){
                    size = config['height_if_null'];
                } else if (config['get_width']){
                    size = config['width_if_null'];
                } else {
                    size = config['width_if_null'];
                }
            }

            w = size;
            h = size;
        } else {
            w = width || config['width_if_null'];
            h = height || config['height_if_null'];
        }

        return [w,h];
    }

});
