define(['jquery', 'core/ajax', 'local_ned_controller/show_ned_notify'], function($, Ajax, NED_Notify) { return {
init: function(notes_id, courseid=0) {
    $(document).ready(function(){
        let notes = NED_Notify.parser_notes_by_elemid(notes_id);
        if (!notes){
            return;
        }

        let close_callback = function($target, $elem){
            let data = {
                close: 1,
                notifyid: Number($elem.data('note-id')),
                dontshow: Number($target.hasClass('dontshow')),
                courseid: courseid
            };

            Ajax.call([{ methodname: 'local_ned_controller_update_user_notifications', args: {notify: data} }])[0]
                .done(function(response){
                    if (response && response.data && response.data.redirect_url){
                        if (window.location.href !== response.data.redirect_url){
                            window.location.href = response.data.redirect_url;
                        }
                    }
                })
                .fail(function(ex) {
                    NED_Notify.error_debug('Failed to ans on notification', ex);
                });

            return false;
        };

        NED_Notify.show(notes, close_callback);
    });
}
};});
